/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.servlet.Servlet;
import org.apache.flink.client.web.JobSubmissionServlet;
import org.apache.flink.client.web.JobsServlet;
import org.apache.flink.client.web.PactJobJSONServlet;
import org.apache.flink.client.web.PlanDisplayServlet;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebInterfaceServer {
    private static final String WEB_ROOT_DIR = "web-docs";
    private static final Logger LOG = LoggerFactory.getLogger(WebInterfaceServer.class);
    private final Server server;

    public WebInterfaceServer(Configuration config, int port) throws IOException {
        String planDumpDirPath;
        File planDumpDir;
        String uploadDirPath;
        File uploadDir;
        if (config == null) {
            config = GlobalConfiguration.getConfiguration();
        }
        String basePath = config.getString("flink.base.dir.path", "");
        URL webRootDir = this.getClass().getClassLoader().getResource(WEB_ROOT_DIR);
        if (webRootDir == null) {
            throw new FileNotFoundException("Cannot start web interface server because the web root dir web-docs is not included in the jar.");
        }
        String tmpDirPath = config.getString("webclient.tempdir", ConfigConstants.DEFAULT_WEB_TMP_DIR);
        File tmpDir = new File(tmpDirPath);
        if (!tmpDir.isAbsolute()) {
            tmpDir = new File(basePath + "/" + tmpDirPath);
        }
        if (!(uploadDir = new File(uploadDirPath = config.getString("webclient.uploaddir", ConfigConstants.DEFAULT_WEB_JOB_STORAGE_DIR))).isAbsolute()) {
            uploadDir = new File(basePath + "/" + uploadDirPath);
        }
        if (!(planDumpDir = new File(planDumpDirPath = config.getString("webclient.plandump", ConfigConstants.DEFAULT_WEB_PLAN_DUMP_DIR))).isAbsolute()) {
            planDumpDir = new File(basePath + "/" + planDumpDirPath);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Setting up web client server, using web-root directory '" + webRootDir.toExternalForm() + "'.");
            LOG.info("Web frontend server will store temporary files in '" + tmpDir.getAbsolutePath() + "', uploaded jobs in '" + uploadDir.getAbsolutePath() + "', plan-json-dumps in '" + planDumpDir.getAbsolutePath() + "'.");
            LOG.info("Web client will submit jobs to JobManager at " + config.getString("jobmanager.rpc.address", null) + ", port " + config.getInteger("jobmanager.rpc.port", 6123) + ".");
        }
        this.server = new Server(port);
        this.checkAndCreateDirectories(tmpDir, true);
        this.checkAndCreateDirectories(uploadDir, true);
        this.checkAndCreateDirectories(planDumpDir, true);
        int jobManagerWebPort = config.getInteger("jobmanager.web.port", 8081);
        ServletContextHandler servletContext = new ServletContextHandler(1);
        servletContext.setContextPath("/");
        servletContext.addServlet(new ServletHolder((Servlet)new PactJobJSONServlet(uploadDir)), "/pactPlan");
        servletContext.addServlet(new ServletHolder((Servlet)new PlanDisplayServlet(jobManagerWebPort)), "/showPlan");
        servletContext.addServlet(new ServletHolder((Servlet)new JobsServlet(uploadDir, tmpDir, "launch.html")), "/jobs");
        servletContext.addServlet(new ServletHolder((Servlet)new JobSubmissionServlet(config, uploadDir, planDumpDir)), "/runJob");
        ResourceHandler pactPlanHandler = new ResourceHandler();
        pactPlanHandler.setDirectoriesListed(false);
        pactPlanHandler.setResourceBase(planDumpDir.getAbsolutePath());
        ContextHandler pactPlanContext = new ContextHandler();
        pactPlanContext.setContextPath("/ajax-plans");
        pactPlanContext.setHandler((Handler)pactPlanHandler);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(false);
        resourceHandler.setResourceBase(webRootDir.toExternalForm());
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)servletContext);
        handlers.addHandler((Handler)pactPlanContext);
        handlers.addHandler((Handler)resourceHandler);
        File af = null;
        String authFile = config.getString("webclient.access", ConfigConstants.DEFAULT_WEB_ACCESS_FILE_PATH);
        if (authFile != null && !(af = new File(authFile)).exists()) {
            LOG.error("The specified file '" + af.getAbsolutePath() + "' with the authentication information is missing. Starting server without HTTP authentication.");
            af = null;
        }
        if (af != null) {
            HashLoginService loginService = new HashLoginService("Flink Query Engine Interface", authFile);
            this.server.addBean((Object)loginService);
            Constraint constraint = new Constraint();
            constraint.setName("BASIC");
            constraint.setAuthenticate(true);
            constraint.setRoles(new String[]{"user"});
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setPathSpec("/*");
            mapping.setConstraint(constraint);
            ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
            sh.addConstraintMapping(mapping);
            sh.setAuthenticator((Authenticator)new BasicAuthenticator());
            sh.setLoginService((LoginService)loginService);
            sh.setStrict(true);
            sh.setHandler((Handler)handlers);
            this.server.setHandler((Handler)sh);
        } else {
            this.server.setHandler((Handler)handlers);
        }
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    private void checkAndCreateDirectories(File f, boolean needWritePermission) throws IOException {
        String dir = f.getAbsolutePath();
        if (f.exists() && !f.isDirectory()) {
            throw new IOException("A none directory file with the same name as the configured directory '" + dir + "' already exists.");
        }
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("Could not create the directory '" + dir + "'.");
        }
        if (!f.canRead() || !f.canExecute()) {
            throw new IOException("The directory '" + dir + "' cannot be read and listed.");
        }
        if (needWritePermission && !f.canWrite()) {
            throw new IOException("No write access could be obtained on directory '" + dir + "'.");
        }
    }
}

