/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.annotate.undirected;

import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.DegreeAnnotationFunctions;
import org.apache.flink.graph.asm.degree.annotate.undirected.VertexDegree;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.LongValue;

public class EdgeSourceDegree<K, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Edge<K, Tuple2<EV, LongValue>>> {
    private OptionalBoolean reduceOnTargetId = new OptionalBoolean(false, false);

    public EdgeSourceDegree<K, VV, EV> setReduceOnTargetId(boolean reduceOnTargetId) {
        this.reduceOnTargetId.set(reduceOnTargetId);
        return this;
    }

    @Override
    protected void mergeConfiguration(GraphAlgorithmWrappingBase other) {
        super.mergeConfiguration(other);
        EdgeSourceDegree rhs = (EdgeSourceDegree)other;
        this.reduceOnTargetId.mergeWith(rhs.reduceOnTargetId);
    }

    @Override
    public DataSet<Edge<K, Tuple2<EV, LongValue>>> runInternal(Graph<K, VV, EV> input) throws Exception {
        DataSet vertexDegrees = (DataSet)input.run(new VertexDegree().setReduceOnTargetId(this.reduceOnTargetId.get()).setParallelism(this.parallelism));
        return ((JoinOperator)input.getEdges().join(vertexDegrees, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{0}).equalTo(new int[]{0}).with(new DegreeAnnotationFunctions.JoinEdgeWithVertexDegree()).setParallelism(this.parallelism)).name("Edge source degree");
    }
}

