/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.generator.GraphGeneratorBase;
import org.apache.flink.graph.generator.GraphGeneratorUtils;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.LongValueSequenceIterator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SplittableIterator;

public class CirculantGraph
extends GraphGeneratorBase<LongValue, NullValue, NullValue> {
    public static final int MINIMUM_VERTEX_COUNT = 2;
    public static final int MINIMUM_OFFSET = 1;
    private final ExecutionEnvironment env;
    private final long vertexCount;
    private List<OffsetRange> offsetRanges = new ArrayList<OffsetRange>();

    public CirculantGraph(ExecutionEnvironment env, long vertexCount) {
        Preconditions.checkArgument((vertexCount >= 2L ? 1 : 0) != 0, (Object)"Vertex count must be at least 2");
        this.env = env;
        this.vertexCount = vertexCount;
    }

    public CirculantGraph addRange(long offset, long length) {
        Preconditions.checkArgument((offset >= 1L ? 1 : 0) != 0, (Object)"Range offset must be at least 1");
        Preconditions.checkArgument((length <= this.vertexCount - offset ? 1 : 0) != 0, (Object)"Range length must not be greater than the vertex count minus the range offset.");
        this.offsetRanges.add(new OffsetRange(offset, length));
        return this;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        DataSet<Vertex<LongValue, NullValue>> vertices = GraphGeneratorUtils.vertexSequence(this.env, this.parallelism, this.vertexCount);
        LongValueSequenceIterator iterator = new LongValueSequenceIterator(0L, this.vertexCount - 1L);
        Collections.sort(this.offsetRanges);
        Iterator<OffsetRange> iter = this.offsetRanges.iterator();
        OffsetRange lastRange = iter.next();
        while (iter.hasNext()) {
            OffsetRange nextRange = iter.next();
            if (lastRange.overlaps(nextRange)) {
                throw new IllegalArgumentException("Overlapping ranges " + lastRange + " and " + nextRange);
            }
            lastRange = nextRange;
        }
        Operator edges = ((FlatMapOperator)((DataSource)((DataSource)this.env.fromParallelCollection((SplittableIterator)iterator, LongValue.class).setParallelism(this.parallelism)).name("Edge iterators")).flatMap((FlatMapFunction)new LinkVertexToOffsets(this.vertexCount, this.offsetRanges)).setParallelism(this.parallelism)).name("Circulant graph edges");
        return Graph.fromDataSet(vertices, edges, this.env);
    }

    public static class OffsetRange
    implements Serializable,
    Comparable<OffsetRange> {
        private long offset;
        private long length;

        public OffsetRange(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getLength() {
            return this.length;
        }

        public long getLastOffset() {
            return this.offset + this.length - 1L;
        }

        public boolean overlaps(OffsetRange other) {
            boolean overlapping = false;
            long lastOffset = this.getLastOffset();
            long otherLastOffset = other.getLastOffset();
            overlapping |= this.offset <= other.offset && other.offset <= lastOffset;
            overlapping |= this.offset <= otherLastOffset && otherLastOffset <= lastOffset;
            overlapping |= other.offset <= this.offset && this.offset <= otherLastOffset;
            return overlapping |= other.offset <= lastOffset && lastOffset <= otherLastOffset;
        }

        public String toString() {
            return Long.toString(this.offset) + ":" + Long.toString(this.length);
        }

        @Override
        public int compareTo(OffsetRange o) {
            int cmp = Long.compare(this.offset, o.offset);
            if (cmp != 0) {
                return cmp;
            }
            return Long.compare(this.length, o.length);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    private static class LinkVertexToOffsets
    implements FlatMapFunction<LongValue, Edge<LongValue, NullValue>> {
        private final long vertexCount;
        private final List<OffsetRange> offsetRanges;
        private LongValue target = new LongValue();
        private Edge<LongValue, NullValue> edge = new Edge<LongValue, NullValue>(null, this.target, NullValue.getInstance());

        public LinkVertexToOffsets(long vertexCount, List<OffsetRange> offsetRanges) {
            this.vertexCount = vertexCount;
            this.offsetRanges = offsetRanges;
        }

        public void flatMap(LongValue source, Collector<Edge<LongValue, NullValue>> out) throws Exception {
            this.edge.f0 = source;
            long sourceID = source.getValue();
            for (OffsetRange offsetRange : this.offsetRanges) {
                long targetID = sourceID + offsetRange.getOffset();
                for (long i = offsetRange.getLength(); i > 0L; --i) {
                    this.target.setValue(targetID++ % this.vertexCount);
                    out.collect(this.edge);
                }
            }
        }
    }
}

