/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;

public class TriangleEnumerator<K extends Comparable<K>, VV, EV>
implements GraphAlgorithm<K, VV, EV, DataSet<Tuple3<K, K, K>>> {
    @Override
    public DataSet<Tuple3<K, K, K>> run(Graph<K, VV, EV> input) throws Exception {
        DataSet<Edge<K, EV>> edges = input.getEdges();
        ReduceOperator edgesWithDegrees = edges.flatMap(new EdgeDuplicator()).groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup(new DegreeCounter()).groupBy(new int[]{0, 1}).reduce(new DegreeJoiner());
        MapOperator edgesByDegree = edgesWithDegrees.map(new EdgeByDegreeProjector());
        MapOperator edgesById = edgesByDegree.map(new EdgeByIdProjector());
        JoinOperator.EquiJoin triangles = edgesByDegree.groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup(new TriadBuilder()).join((DataSet)edgesById, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{1, 2}).equalTo(new int[]{0, 1}).with(new TriadFilter());
        return triangles;
    }

    public static final class Triad<K>
    extends Tuple3<K, K, K> {
        private static final long serialVersionUID = 1L;
        public static final int V1 = 0;
        public static final int V2 = 1;
        public static final int V3 = 2;

        public K getFirstVertex() {
            return (K)this.getField(0);
        }

        public K getSecondVertex() {
            return (K)this.getField(1);
        }

        public K getThirdVertex() {
            return (K)this.getField(2);
        }

        public void setFirstVertex(K vertex1) {
            this.setField(vertex1, 0);
        }

        public void setSecondVertex(K vertex2) {
            this.setField(vertex2, 1);
        }

        public void setThirdVertex(K vertex3) {
            this.setField(vertex3, 2);
        }
    }

    public static final class EdgeWithDegrees<K>
    extends Tuple4<K, K, Integer, Integer> {
        public static final int V1 = 0;
        public static final int V2 = 1;
        public static final int D1 = 2;
        public static final int D2 = 3;

        public K getFirstVertex() {
            return (K)this.getField(0);
        }

        public K getSecondVertex() {
            return (K)this.getField(1);
        }

        public Integer getFirstDegree() {
            return (Integer)this.getField(2);
        }

        public Integer getSecondDegree() {
            return (Integer)this.getField(3);
        }

        public void setFirstVertex(K vertex1) {
            this.setField(vertex1, 0);
        }

        public void setSecondVertex(K vertex2) {
            this.setField(vertex2, 1);
        }

        public void setFirstDegree(Integer degree1) {
            this.setField(degree1, 2);
        }

        public void setSecondDegree(Integer degree2) {
            this.setField(degree2, 3);
        }

        public void copyFrom(EdgeWithDegrees<K> edge) {
            this.setFirstVertex(edge.getFirstVertex());
            this.setSecondVertex(edge.getSecondVertex());
            this.setFirstDegree(edge.getFirstDegree());
            this.setSecondDegree(edge.getSecondDegree());
        }
    }

    private static final class TriadFilter<K>
    implements JoinFunction<Triad<K>, Edge<K, NullValue>, Tuple3<K, K, K>> {
        private TriadFilter() {
        }

        public Tuple3<K, K, K> join(Triad<K> triad, Edge<K, NullValue> edge) throws Exception {
            return new Tuple3(triad.getFirstVertex(), triad.getSecondVertex(), triad.getThirdVertex());
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static final class TriadBuilder<K extends Comparable<K>>
    implements GroupReduceFunction<Edge<K, NullValue>, Triad<K>> {
        private final List<K> vertices = new ArrayList<K>();
        private final Triad<K> outTriad = new Triad();

        private TriadBuilder() {
        }

        public void reduce(Iterable<Edge<K, NullValue>> edgesIter, Collector<Triad<K>> out) throws Exception {
            Iterator<Edge<K, NullValue>> edges = edgesIter.iterator();
            this.vertices.clear();
            Edge<K, NullValue> firstEdge = edges.next();
            this.outTriad.setFirstVertex(firstEdge.getSource());
            this.vertices.add(firstEdge.getTarget());
            while (edges.hasNext()) {
                Comparable higherVertexId = (Comparable)edges.next().getTarget();
                for (Comparable lowerVertexId : this.vertices) {
                    this.outTriad.setSecondVertex(lowerVertexId);
                    this.outTriad.setThirdVertex(higherVertexId);
                    out.collect(this.outTriad);
                }
                this.vertices.add(higherVertexId);
            }
        }
    }

    private static final class EdgeByIdProjector<K extends Comparable<K>>
    implements MapFunction<Edge<K, NullValue>, Edge<K, NullValue>> {
        private EdgeByIdProjector() {
        }

        public Edge<K, NullValue> map(Edge<K, NullValue> inEdge) throws Exception {
            if (((Comparable)inEdge.getSource()).compareTo(inEdge.getTarget()) > 0) {
                inEdge = inEdge.reverse();
            }
            return inEdge;
        }
    }

    private static final class EdgeByDegreeProjector<K>
    implements MapFunction<EdgeWithDegrees<K>, Edge<K, NullValue>> {
        private Edge<K, NullValue> outEdge = new Edge();

        private EdgeByDegreeProjector() {
        }

        public Edge<K, NullValue> map(EdgeWithDegrees<K> inEdge) throws Exception {
            this.outEdge.setSource(inEdge.getFirstVertex());
            this.outEdge.setTarget(inEdge.getSecondVertex());
            this.outEdge.setValue(NullValue.getInstance());
            if (inEdge.getFirstDegree() > inEdge.getSecondDegree()) {
                this.outEdge = this.outEdge.reverse();
            }
            return this.outEdge;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0;1"})
    private static final class DegreeJoiner<K>
    implements ReduceFunction<EdgeWithDegrees<K>> {
        private final EdgeWithDegrees<K> outEdge = new EdgeWithDegrees();

        private DegreeJoiner() {
        }

        public EdgeWithDegrees<K> reduce(EdgeWithDegrees<K> edge1, EdgeWithDegrees<K> edge2) throws Exception {
            this.outEdge.copyFrom(edge1);
            if (edge1.getFirstDegree() == 0 && edge1.getSecondDegree() != 0) {
                this.outEdge.setFirstDegree(edge2.getFirstDegree());
            } else if (edge1.getFirstDegree() != 0 && edge1.getSecondDegree() == 0) {
                this.outEdge.setSecondDegree(edge2.getSecondDegree());
            }
            return this.outEdge;
        }
    }

    private static final class DegreeCounter<K extends Comparable<K>, EV>
    implements GroupReduceFunction<Edge<K, EV>, EdgeWithDegrees<K>> {
        final ArrayList<K> otherVertices = new ArrayList();
        final EdgeWithDegrees<K> outputEdge = new EdgeWithDegrees();

        private DegreeCounter() {
        }

        public void reduce(Iterable<Edge<K, EV>> edgesIter, Collector<EdgeWithDegrees<K>> out) {
            Iterator<Edge<K, EV>> edges = edgesIter.iterator();
            this.otherVertices.clear();
            Edge<K, EV> edge = edges.next();
            Comparable groupVertex = (Comparable)edge.getSource();
            this.otherVertices.add(edge.getTarget());
            while (edges.hasNext()) {
                edge = edges.next();
                Comparable otherVertex = (Comparable)edge.getTarget();
                if (this.otherVertices.contains(otherVertex) || otherVertex == groupVertex) continue;
                this.otherVertices.add(otherVertex);
            }
            int degree = this.otherVertices.size();
            for (Comparable otherVertex : this.otherVertices) {
                if (groupVertex.compareTo(otherVertex) < 0) {
                    this.outputEdge.setFirstVertex(groupVertex);
                    this.outputEdge.setFirstDegree(degree);
                    this.outputEdge.setSecondVertex(otherVertex);
                    this.outputEdge.setSecondDegree(0);
                } else {
                    this.outputEdge.setFirstVertex(otherVertex);
                    this.outputEdge.setFirstDegree(0);
                    this.outputEdge.setSecondVertex(groupVertex);
                    this.outputEdge.setSecondDegree(degree);
                }
                out.collect(this.outputEdge);
            }
        }
    }

    private static final class EdgeDuplicator<K, EV>
    implements FlatMapFunction<Edge<K, EV>, Edge<K, EV>> {
        private EdgeDuplicator() {
        }

        public void flatMap(Edge<K, EV> edge, Collector<Edge<K, EV>> out) throws Exception {
            out.collect(edge);
            Edge<K, EV> reversed = edge.reverse();
            out.collect(reversed);
        }
    }
}

