/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class JDBCTypeUtil {
    private static final Map<TypeInformation<?>, Integer> TYPE_MAPPING;
    private static final Map<Integer, String> SQL_TYPE_NAMES;

    private JDBCTypeUtil() {
    }

    static int typeInformationToSqlType(TypeInformation<?> type) {
        if (TYPE_MAPPING.containsKey(type)) {
            return TYPE_MAPPING.get(type);
        }
        if (type instanceof ObjectArrayTypeInfo || type instanceof PrimitiveArrayTypeInfo) {
            return 2003;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    static String getTypeName(int type) {
        return SQL_TYPE_NAMES.get(type);
    }

    static String getTypeName(TypeInformation<?> type) {
        return SQL_TYPE_NAMES.get(JDBCTypeUtil.typeInformationToSqlType(type));
    }

    static TableSchema normalizeTableSchema(TableSchema schema) {
        TableSchema.Builder physicalSchemaBuilder = TableSchema.builder();
        schema.getTableColumns().forEach(c -> {
            if (!c.isGenerated()) {
                LogicalTypeRoot root = c.getType().getLogicalType().getTypeRoot();
                DataType type = root == LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE ? c.getType().bridgedTo(Timestamp.class) : (root == LogicalTypeRoot.DATE ? c.getType().bridgedTo(Date.class) : (root == LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE ? c.getType().bridgedTo(Time.class) : c.getType()));
                physicalSchemaBuilder.field(c.getName(), type);
            }
        });
        return physicalSchemaBuilder.build();
    }

    static {
        HashMap<Object, Integer> m = new HashMap<Object, Integer>();
        m.put(BasicTypeInfo.STRING_TYPE_INFO, 12);
        m.put(BasicTypeInfo.BOOLEAN_TYPE_INFO, 16);
        m.put(BasicTypeInfo.BYTE_TYPE_INFO, -6);
        m.put(BasicTypeInfo.SHORT_TYPE_INFO, 5);
        m.put(BasicTypeInfo.INT_TYPE_INFO, 4);
        m.put(BasicTypeInfo.LONG_TYPE_INFO, -5);
        m.put(BasicTypeInfo.FLOAT_TYPE_INFO, 7);
        m.put(BasicTypeInfo.DOUBLE_TYPE_INFO, 8);
        m.put(SqlTimeTypeInfo.DATE, 91);
        m.put(SqlTimeTypeInfo.TIME, 92);
        m.put(SqlTimeTypeInfo.TIMESTAMP, 93);
        m.put(BasicTypeInfo.BIG_DEC_TYPE_INFO, 3);
        m.put(PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO, -2);
        TYPE_MAPPING = Collections.unmodifiableMap(m);
        HashMap<Integer, String> names = new HashMap<Integer, String>();
        names.put(12, "VARCHAR");
        names.put(16, "BOOLEAN");
        names.put(-6, "TINYINT");
        names.put(5, "SMALLINT");
        names.put(4, "INTEGER");
        names.put(-5, "BIGINT");
        names.put(6, "FLOAT");
        names.put(8, "DOUBLE");
        names.put(1, "CHAR");
        names.put(91, "DATE");
        names.put(92, "TIME");
        names.put(93, "TIMESTAMP");
        names.put(3, "DECIMAL");
        names.put(-2, "BINARY");
        SQL_TYPE_NAMES = Collections.unmodifiableMap(names);
    }
}

