/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.math;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.F2jBLAS;
import org.apache.flink.ml.math.DenseMatrix;
import org.apache.flink.ml.math.DenseVector;
import org.apache.flink.ml.math.SparseVector;
import org.apache.flink.ml.math.Vector;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BLAS$
implements Serializable {
    public static final BLAS$ MODULE$;
    private transient BLAS _f2jBLAS;
    private transient BLAS _nativeBLAS;

    static {
        new BLAS$();
    }

    private BLAS _f2jBLAS() {
        return this._f2jBLAS;
    }

    private void _f2jBLAS_$eq(BLAS x$1) {
        this._f2jBLAS = x$1;
    }

    private BLAS _nativeBLAS() {
        return this._nativeBLAS;
    }

    private void _nativeBLAS_$eq(BLAS x$1) {
        this._nativeBLAS = x$1;
    }

    private BLAS f2jBLAS() {
        if (this._f2jBLAS() == null) {
            this._f2jBLAS_$eq((BLAS)new F2jBLAS());
        }
        return this._f2jBLAS();
    }

    public void axpy(double a, Vector x, Vector y) {
        block2: {
            block5: {
                block4: {
                    Vector vector;
                    DenseVector denseVector;
                    block3: {
                        Predef$.MODULE$.require(x.size() == y.size());
                        Vector vector2 = y;
                        if (!(vector2 instanceof DenseVector)) break block2;
                        denseVector = (DenseVector)vector2;
                        vector = x;
                        if (!(vector instanceof SparseVector)) break block3;
                        SparseVector sparseVector = (SparseVector)vector;
                        this.axpy(a, sparseVector, denseVector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!(vector instanceof DenseVector)) break block5;
                    DenseVector denseVector2 = (DenseVector)vector;
                    this.axpy(a, denseVector2, denseVector);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"axpy doesn't support x type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass()})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"axpy only supports adding to a dense vector but got type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{y.getClass()})));
    }

    private void axpy(double a, DenseVector x, DenseVector y) {
        int n = x.size();
        this.f2jBLAS().daxpy(n, a, x.data(), 1, y.data(), 1);
    }

    private void axpy(double a, SparseVector x, DenseVector y) {
        double[] xValues = x.data();
        int[] xIndices = x.indices();
        double[] yValues = y.data();
        int nnz = xIndices.length;
        if (a == 1.0) {
            for (int k = 0; k < nnz; ++k) {
                int n = xIndices[k];
                yValues[n] = yValues[n] + xValues[k];
            }
        } else {
            for (int k = 0; k < nnz; ++k) {
                int n = xIndices[k];
                yValues[n] = yValues[n] + a * xValues[k];
            }
        }
    }

    public double dot(Vector x, Vector y) {
        block6: {
            double d;
            block3: {
                Tuple2 tuple2;
                block5: {
                    block4: {
                        block2: {
                            Predef$.MODULE$.require(x.size() == y.size(), (Function0)new Serializable(x, y){
                                public static final long serialVersionUID = 0L;
                                private final Vector x$1;
                                private final Vector y$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"BLAS.dot(x: Vector, y:Vector) was given Vectors with non-matching sizes: x.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.x$1.size())).append((Object)", y.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.y$1.size())).toString();
                                }
                                {
                                    this.x$1 = x$1;
                                    this.y$1 = y$1;
                                }
                            });
                            tuple2 = new Tuple2((Object)x, (Object)y);
                            if (tuple2 == null) break block2;
                            Vector dx = (Vector)tuple2._1();
                            Vector dy = (Vector)tuple2._2();
                            if (!(dx instanceof DenseVector)) break block2;
                            DenseVector denseVector = (DenseVector)dx;
                            if (!(dy instanceof DenseVector)) break block2;
                            DenseVector denseVector2 = (DenseVector)dy;
                            d = this.dot(denseVector, denseVector2);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Vector sx = (Vector)tuple2._1();
                        Vector dy = (Vector)tuple2._2();
                        if (!(sx instanceof SparseVector)) break block4;
                        SparseVector sparseVector = (SparseVector)sx;
                        if (!(dy instanceof DenseVector)) break block4;
                        DenseVector denseVector = (DenseVector)dy;
                        d = this.dot(sparseVector, denseVector);
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    Vector dx = (Vector)tuple2._1();
                    Vector sy = (Vector)tuple2._2();
                    if (!(dx instanceof DenseVector)) break block5;
                    DenseVector denseVector = (DenseVector)dx;
                    if (!(sy instanceof SparseVector)) break block5;
                    SparseVector sparseVector = (SparseVector)sy;
                    d = this.dot(sparseVector, denseVector);
                    break block3;
                }
                if (tuple2 == null) break block6;
                Vector sx = (Vector)tuple2._1();
                Vector sy = (Vector)tuple2._2();
                if (!(sx instanceof SparseVector)) break block6;
                SparseVector sparseVector = (SparseVector)sx;
                if (!(sy instanceof SparseVector)) break block6;
                SparseVector sparseVector2 = (SparseVector)sy;
                d = this.dot(sparseVector, sparseVector2);
            }
            return d;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dot doesn't support (", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass(), y.getClass()})));
    }

    private double dot(DenseVector x, DenseVector y) {
        int n = x.size();
        return this.f2jBLAS().ddot(n, x.data(), 1, y.data(), 1);
    }

    private double dot(SparseVector x, DenseVector y) {
        double[] xValues = x.data();
        int[] xIndices = x.indices();
        double[] yValues = y.data();
        int nnz = xIndices.length;
        double sum = 0.0;
        for (int k = 0; k < nnz; ++k) {
            sum += xValues[k] * yValues[xIndices[k]];
        }
        return sum;
    }

    private double dot(SparseVector x, SparseVector y) {
        double[] xValues = x.data();
        int[] xIndices = x.indices();
        double[] yValues = y.data();
        int[] yIndices = y.indices();
        int nnzx = xIndices.length;
        int nnzy = yIndices.length;
        int ky = 0;
        double sum = 0.0;
        for (int kx = 0; kx < nnzx && ky < nnzy; ++kx) {
            int ix = xIndices[kx];
            while (ky < nnzy && yIndices[ky] < ix) {
                ++ky;
            }
            if (ky >= nnzy || yIndices[ky] != ix) continue;
            sum += xValues[kx] * yValues[ky];
            ++ky;
        }
        return sum;
    }

    public void copy(Vector x, Vector y) {
        block5: {
            Vector vector;
            block8: {
                block7: {
                    DenseVector denseVector;
                    int n;
                    block6: {
                        n = y.size();
                        Predef$.MODULE$.require(x.size() == n);
                        Vector vector2 = y;
                        if (!(vector2 instanceof DenseVector)) break block5;
                        denseVector = (DenseVector)vector2;
                        vector = x;
                        if (!(vector instanceof SparseVector)) break block6;
                        SparseVector sparseVector = (SparseVector)vector;
                        int[] sxIndices = sparseVector.indices();
                        double[] sxValues = sparseVector.data();
                        double[] dyValues = denseVector.data();
                        int nnz = sxIndices.length;
                        int i = 0;
                        for (int k = 0; k < nnz; ++k) {
                            int j = sxIndices[k];
                            while (i < j) {
                                dyValues[i] = 0.0;
                                ++i;
                            }
                            dyValues[i] = sxValues[k];
                            ++i;
                        }
                        while (i < n) {
                            dyValues[i] = 0.0;
                            ++i;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    if (!(vector instanceof DenseVector)) break block8;
                    DenseVector denseVector2 = (DenseVector)vector;
                    Array$.MODULE$.copy((Object)denseVector2.data(), 0, (Object)denseVector.data(), 0, n);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new MatchError((Object)vector);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y must be dense in copy but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{y.getClass()})));
    }

    public void scal(double a, Vector x) {
        block4: {
            block3: {
                Vector vector;
                block2: {
                    vector = x;
                    if (!(vector instanceof SparseVector)) break block2;
                    SparseVector sparseVector = (SparseVector)vector;
                    this.f2jBLAS().dscal(sparseVector.data().length, a, sparseVector.data(), 1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(vector instanceof DenseVector)) break block4;
                DenseVector denseVector = (DenseVector)vector;
                this.f2jBLAS().dscal(denseVector.data().length, a, denseVector.data(), 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scal doesn't support vector type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass()})));
    }

    private BLAS nativeBLAS() {
        if (this._nativeBLAS() == null) {
            this._nativeBLAS_$eq(BLAS.getInstance());
        }
        return this._nativeBLAS();
    }

    public void syr(double alpha, Vector x, DenseMatrix A) {
        block4: {
            block3: {
                Vector vector;
                block2: {
                    int nA;
                    int mA = A.numRows();
                    Predef$.MODULE$.require(mA == (nA = A.numCols()), (Function0)new Serializable(mA, nA){
                        public static final long serialVersionUID = 0L;
                        private final int mA$1;
                        private final int nA$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A is not a square matrix (and hence is not symmetric). A: ", " x ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mA$1), BoxesRunTime.boxToInteger((int)this.nA$1)}));
                        }
                        {
                            this.mA$1 = mA$1;
                            this.nA$1 = nA$1;
                        }
                    });
                    Predef$.MODULE$.require(mA == x.size(), (Function0)new Serializable(x, mA, nA){
                        public static final long serialVersionUID = 0L;
                        private final Vector x$2;
                        private final int mA$1;
                        private final int nA$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The size of x doesn't match the rank of A. A: ", " x ", ", x: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mA$1), BoxesRunTime.boxToInteger((int)this.nA$1), BoxesRunTime.boxToInteger((int)this.x$2.size())}));
                        }
                        {
                            this.x$2 = x$2;
                            this.mA$1 = mA$1;
                            this.nA$1 = nA$1;
                        }
                    });
                    vector = x;
                    if (!(vector instanceof DenseVector)) break block2;
                    DenseVector denseVector = (DenseVector)vector;
                    this.syr(alpha, denseVector, A);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(vector instanceof SparseVector)) break block4;
                SparseVector sparseVector = (SparseVector)vector;
                this.syr(alpha, sparseVector, A);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"syr doesn't support vector type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass()})));
    }

    private void syr(double alpha, DenseVector x, DenseMatrix A) {
        int nA = A.numRows();
        int mA = A.numCols();
        this.nativeBLAS().dsyr("U", x.size(), alpha, x.data(), 1, A.data(), nA);
        for (int i = 0; i < mA; ++i) {
            for (int j = i + 1; j < nA; ++j) {
                A.update(j, i, A.apply(i, j));
            }
        }
    }

    private void syr(double alpha, SparseVector x, DenseMatrix A) {
        int mA = A.numCols();
        int[] xIndices = x.indices();
        double[] xValues = x.data();
        int nnz = xValues.length;
        double[] Avalues = A.data();
        for (int i = 0; i < nnz; ++i) {
            double multiplier = alpha * xValues[i];
            int offset = xIndices[i] * mA;
            for (int j = 0; j < nnz; ++j) {
                int n = xIndices[j] + offset;
                Avalues[n] = Avalues[n] + multiplier * xValues[j];
            }
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BLAS$() {
        MODULE$ = this;
    }
}

