/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.FoldApplyAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.PassThroughAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ReduceApplyAllWindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.EvictingWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueAllWindowFunction;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecordSerializer;

@Public
public class AllWindowedStream<T, W extends Window> {
    private final KeyedStream<T, Byte> input;
    private final WindowAssigner<? super T, W> windowAssigner;
    private Trigger<? super T, ? super W> trigger;
    private Evictor<? super T, ? super W> evictor;
    private long allowedLateness = 0L;

    @PublicEvolving
    public AllWindowedStream(DataStream<T> input, WindowAssigner<? super T, W> windowAssigner) {
        this.input = input.keyBy(new NullByteKeySelector());
        this.windowAssigner = windowAssigner;
        this.trigger = windowAssigner.getDefaultTrigger(input.getExecutionEnvironment());
    }

    @PublicEvolving
    public AllWindowedStream<T, W> trigger(Trigger<? super T, ? super W> trigger) {
        if (this.windowAssigner instanceof MergingWindowAssigner && !trigger.canMerge()) {
            throw new UnsupportedOperationException("A merging window assigner cannot be used with a trigger that does not support merging.");
        }
        this.trigger = trigger;
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> allowedLateness(Time lateness) {
        long millis = lateness.toMilliseconds();
        if (this.allowedLateness < 0L) {
            throw new IllegalArgumentException("The allowed lateness cannot be negative.");
        }
        if (this.allowedLateness != 0L && !this.windowAssigner.isEventTime()) {
            throw new IllegalArgumentException("Setting the allowed lateness is only valid for event-time windows.");
        }
        this.allowedLateness = millis;
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> evictor(Evictor<? super T, ? super W> evictor) {
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            throw new UnsupportedOperationException("Cannot use a merging WindowAssigner with an Evictor.");
        }
        this.evictor = evictor;
        return this;
    }

    public SingleOutputStreamOperator<T> reduce(ReduceFunction<T> function) {
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of reduce can not be a RichFunction. Please use apply(ReduceFunction, WindowFunction) instead.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        return this.apply(function, new PassThroughAllWindowFunction());
    }

    public <R> SingleOutputStreamOperator<R> fold(R initialValue, FoldFunction<T, R> function) {
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("FoldFunction can not be a RichFunction. Please use apply(FoldFunction, WindowFunction) instead.");
        }
        TypeInformation resultType = TypeExtractor.getFoldReturnTypes(function, this.input.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.fold(initialValue, function, resultType);
    }

    public <R> SingleOutputStreamOperator<R> fold(R initialValue, FoldFunction<T, R> function, TypeInformation<R> resultType) {
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("FoldFunction can not be a RichFunction. Please use apply(FoldFunction, WindowFunction) instead.");
        }
        return this.apply(initialValue, function, new PassThroughAllWindowFunction(), resultType);
    }

    public <R> SingleOutputStreamOperator<R> apply(AllWindowFunction<T, R, W> function) {
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, AllWindowFunction.class, (boolean)true, (boolean)true, this.getInputType(), null, (boolean)false);
        return this.apply(function, resultType);
    }

    public <R> SingleOutputStreamOperator<R> apply(AllWindowFunction<T, R, W> function, TypeInformation<R> resultType) {
        WindowOperator operator;
        String opName;
        function = this.input.getExecutionEnvironment().clean(function);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        KeySelector<T, Byte> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", new StreamRecordSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig())));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + this.evictor + ", " + udfName + ")";
            operator = new EvictingWindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableAllWindowFunction<T, R, W>(function), this.trigger, this.evictor, this.allowedLateness);
        } else {
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + udfName + ")";
            operator = new WindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableAllWindowFunction<T, R, W>(function), this.trigger, this.allowedLateness);
        }
        return this.input.transform(opName, resultType, operator).setParallelism(1);
    }

    public <R> SingleOutputStreamOperator<R> apply(ReduceFunction<T> reduceFunction, AllWindowFunction<T, R, W> function) {
        TypeInformation inType = this.input.getType();
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, AllWindowFunction.class, (boolean)true, (boolean)true, inType, null, (boolean)false);
        return this.apply(reduceFunction, function, resultType);
    }

    public <R> SingleOutputStreamOperator<R> apply(ReduceFunction<T> reduceFunction, AllWindowFunction<T, R, W> function, TypeInformation<R> resultType) {
        WindowOperator operator;
        String opName;
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of apply can not be a RichFunction.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        reduceFunction = this.input.getExecutionEnvironment().clean(reduceFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        KeySelector<T, Byte> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", new StreamRecordSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig())));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + this.evictor + ", " + udfName + ")";
            operator = new EvictingWindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableAllWindowFunction<W, T, R>(new ReduceApplyAllWindowFunction<W, T, R>(reduceFunction, function)), this.trigger, this.evictor, this.allowedLateness);
        } else {
            ReducingStateDescriptor stateDesc = new ReducingStateDescriptor("window-contents", reduceFunction, this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + udfName + ")";
            operator = new WindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalSingleValueAllWindowFunction<T, R, W>(function), this.trigger, this.allowedLateness);
        }
        return this.input.transform(opName, resultType, operator).setParallelism(1);
    }

    public <R> SingleOutputStreamOperator<R> apply(R initialValue, FoldFunction<T, R> foldFunction, AllWindowFunction<R, R, W> function) {
        TypeInformation resultType = TypeExtractor.getFoldReturnTypes(foldFunction, this.input.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.apply(initialValue, foldFunction, function, resultType);
    }

    public <R> SingleOutputStreamOperator<R> apply(R initialValue, FoldFunction<T, R> foldFunction, AllWindowFunction<R, R, W> function, TypeInformation<R> resultType) {
        WindowOperator operator;
        String opName;
        if (foldFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of apply can not be a RichFunction.");
        }
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            throw new UnsupportedOperationException("Fold cannot be used with a merging WindowAssigner.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        foldFunction = this.input.getExecutionEnvironment().clean(foldFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        KeySelector<T, Byte> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", new StreamRecordSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig())));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + this.evictor + ", " + udfName + ")";
            operator = new EvictingWindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableAllWindowFunction<W, T, R>(new FoldApplyAllWindowFunction<W, T, R>(initialValue, foldFunction, function)), this.trigger, this.evictor, this.allowedLateness);
        } else {
            FoldingStateDescriptor stateDesc = new FoldingStateDescriptor("window-contents", initialValue, foldFunction, resultType.createSerializer(this.getExecutionEnvironment().getConfig()));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + udfName + ")";
            operator = new WindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalSingleValueAllWindowFunction<R, R, W>(function), this.trigger, this.allowedLateness);
        }
        return this.input.transform(opName, resultType, operator).setParallelism(1);
    }

    public SingleOutputStreamOperator<T> sum(int positionToSum) {
        return this.aggregate(new SumAggregator(positionToSum, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> sum(String field) {
        return this.aggregate(new SumAggregator(field, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> min(int positionToMin) {
        return this.aggregate(new ComparableAggregator(positionToMin, this.input.getType(), AggregationFunction.AggregationType.MIN, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> min(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MIN, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> minBy(int positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T> minBy(String positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T> minBy(int positionToMinBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMinBy, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> minBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> max(int positionToMax) {
        return this.aggregate(new ComparableAggregator(positionToMax, this.input.getType(), AggregationFunction.AggregationType.MAX, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> max(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAX, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> maxBy(int positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T> maxBy(String positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T> maxBy(int positionToMaxBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMaxBy, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> maxBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    private SingleOutputStreamOperator<T> aggregate(AggregationFunction<T> aggregator) {
        return this.reduce(aggregator);
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.input.getExecutionEnvironment();
    }

    public TypeInformation<T> getInputType() {
        return this.input.getType();
    }

    private static class NullByteKeySelector<T>
    implements KeySelector<T, Byte> {
        private static final long serialVersionUID = 1L;

        private NullByteKeySelector() {
        }

        public Byte getKey(T value) throws Exception {
            return (byte)0;
        }
    }
}

