/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.CsvOutputFormat;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.datastream.AllWindowedStream;
import org.apache.flink.streaming.api.datastream.CoGroupedStreams;
import org.apache.flink.streaming.api.datastream.ConnectedStreams;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.IterativeStream;
import org.apache.flink.streaming.api.datastream.JoinedStreams;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.SplitStream;
import org.apache.flink.streaming.api.datastream.StreamProjection;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.TimestampExtractor;
import org.apache.flink.streaming.api.functions.sink.OutputFormatSinkFunction;
import org.apache.flink.streaming.api.functions.sink.PrintSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.sink.SocketClientSink;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamFilter;
import org.apache.flink.streaming.api.operators.StreamFlatMap;
import org.apache.flink.streaming.api.operators.StreamMap;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.streaming.api.transformations.UnionTransformation;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.CountEvictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.PurgingTrigger;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.ExtractTimestampsOperator;
import org.apache.flink.streaming.runtime.operators.TimestampsAndPeriodicWatermarksOperator;
import org.apache.flink.streaming.runtime.operators.TimestampsAndPunctuatedWatermarksOperator;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.CustomPartitionerWrapper;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.partitioner.RescalePartitioner;
import org.apache.flink.streaming.runtime.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.util.keys.KeySelectorUtil;
import org.apache.flink.streaming.util.serialization.SerializationSchema;
import org.apache.flink.util.Preconditions;

@Public
public class DataStream<T> {
    protected final StreamExecutionEnvironment environment;
    protected final StreamTransformation<T> transformation;

    public DataStream(StreamExecutionEnvironment environment, StreamTransformation<T> transformation) {
        this.environment = (StreamExecutionEnvironment)Preconditions.checkNotNull((Object)environment, (String)"Execution Environment must not be null.");
        this.transformation = (StreamTransformation)Preconditions.checkNotNull(transformation, (String)"Stream Transformation must not be null.");
    }

    @Internal
    public int getId() {
        return this.transformation.getId();
    }

    public int getParallelism() {
        return this.transformation.getParallelism();
    }

    public TypeInformation<T> getType() {
        return this.transformation.getOutputType();
    }

    protected <F> F clean(F f) {
        return this.getExecutionEnvironment().clean(f);
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.environment;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.environment.getConfig();
    }

    @SafeVarargs
    public final DataStream<T> union(DataStream<T> ... streams) {
        ArrayList unionedTransforms = new ArrayList();
        unionedTransforms.add(this.transformation);
        for (DataStream<T> newStream : streams) {
            if (!this.getType().equals(newStream.getType())) {
                throw new IllegalArgumentException("Cannot union streams of different types: " + this.getType() + " and " + newStream.getType());
            }
            unionedTransforms.add(newStream.getTransformation());
        }
        return new DataStream(this.environment, new UnionTransformation(unionedTransforms));
    }

    public SplitStream<T> split(OutputSelector<T> outputSelector) {
        return new SplitStream<T>(this, this.clean(outputSelector));
    }

    public <R> ConnectedStreams<T, R> connect(DataStream<R> dataStream) {
        return new ConnectedStreams(this.environment, this, dataStream);
    }

    public <K> KeyedStream<T, K> keyBy(KeySelector<T, K> key) {
        return new KeyedStream<T, K>(this, this.clean(key));
    }

    public KeyedStream<T, Tuple> keyBy(int ... fields) {
        if (this.getType() instanceof BasicArrayTypeInfo || this.getType() instanceof PrimitiveArrayTypeInfo) {
            return this.keyBy(KeySelectorUtil.getSelectorForArray(fields, this.getType()));
        }
        return this.keyBy((Keys<T>)new Keys.ExpressionKeys(fields, this.getType()));
    }

    public KeyedStream<T, Tuple> keyBy(String ... fields) {
        return this.keyBy((Keys<T>)new Keys.ExpressionKeys(fields, this.getType()));
    }

    private KeyedStream<T, Tuple> keyBy(Keys<T> keys) {
        return new KeyedStream<T, Tuple>(this, this.clean(KeySelectorUtil.getSelectorForKeys(keys, this.getType(), this.getExecutionConfig())));
    }

    public <K> DataStream<T> partitionCustom(Partitioner<K> partitioner, int field) {
        Keys.ExpressionKeys outExpressionKeys = new Keys.ExpressionKeys(new int[]{field}, this.getType());
        return this.partitionCustom(partitioner, (Keys<T>)outExpressionKeys);
    }

    public <K> DataStream<T> partitionCustom(Partitioner<K> partitioner, String field) {
        Keys.ExpressionKeys outExpressionKeys = new Keys.ExpressionKeys(new String[]{field}, this.getType());
        return this.partitionCustom(partitioner, (Keys<T>)outExpressionKeys);
    }

    public <K> DataStream<T> partitionCustom(Partitioner<K> partitioner, KeySelector<T, K> keySelector) {
        return this.setConnectionType(new CustomPartitionerWrapper<K, T>(this.clean(partitioner), this.clean(keySelector)));
    }

    private <K> DataStream<T> partitionCustom(Partitioner<K> partitioner, Keys<T> keys) {
        KeySelector<T, K> keySelector = KeySelectorUtil.getSelectorForOneKey(keys, partitioner, this.getType(), this.getExecutionConfig());
        return this.setConnectionType(new CustomPartitionerWrapper<K, T>(this.clean(partitioner), this.clean(keySelector)));
    }

    public DataStream<T> broadcast() {
        return this.setConnectionType(new BroadcastPartitioner());
    }

    @PublicEvolving
    public DataStream<T> shuffle() {
        return this.setConnectionType(new ShufflePartitioner());
    }

    public DataStream<T> forward() {
        return this.setConnectionType(new ForwardPartitioner());
    }

    public DataStream<T> rebalance() {
        return this.setConnectionType(new RebalancePartitioner());
    }

    @PublicEvolving
    public DataStream<T> rescale() {
        return this.setConnectionType(new RescalePartitioner());
    }

    @PublicEvolving
    public DataStream<T> global() {
        return this.setConnectionType(new GlobalPartitioner());
    }

    @PublicEvolving
    public IterativeStream<T> iterate() {
        return new IterativeStream(this, 0L);
    }

    @PublicEvolving
    public IterativeStream<T> iterate(long maxWaitTimeMillis) {
        return new IterativeStream(this, maxWaitTimeMillis);
    }

    public <R> SingleOutputStreamOperator<R> map(MapFunction<T, R> mapper) {
        TypeInformation outType = TypeExtractor.getMapReturnTypes(this.clean(mapper), this.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.transform("Map", outType, new StreamMap<T, R>(this.clean(mapper)));
    }

    public <R> SingleOutputStreamOperator<R> flatMap(FlatMapFunction<T, R> flatMapper) {
        TypeInformation outType = TypeExtractor.getFlatMapReturnTypes(this.clean(flatMapper), this.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.transform("Flat Map", outType, new StreamFlatMap<T, R>(this.clean(flatMapper)));
    }

    public SingleOutputStreamOperator<T> filter(FilterFunction<T> filter) {
        return this.transform("Filter", this.getType(), new StreamFilter<T>(this.clean(filter)));
    }

    @PublicEvolving
    public <R extends Tuple> SingleOutputStreamOperator<R> project(int ... fieldIndexes) {
        return new StreamProjection(this, fieldIndexes).projectTupleX();
    }

    public <T2> CoGroupedStreams<T, T2> coGroup(DataStream<T2> otherStream) {
        return new CoGroupedStreams(this, otherStream);
    }

    public <T2> JoinedStreams<T, T2> join(DataStream<T2> otherStream) {
        return new JoinedStreams(this, otherStream);
    }

    public AllWindowedStream<T, TimeWindow> timeWindowAll(Time size) {
        if (this.environment.getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime) {
            return this.windowAll(TumblingProcessingTimeWindows.of(size));
        }
        return this.windowAll(TumblingEventTimeWindows.of(size));
    }

    public AllWindowedStream<T, TimeWindow> timeWindowAll(Time size, Time slide) {
        if (this.environment.getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime) {
            return this.windowAll(SlidingProcessingTimeWindows.of(size, slide));
        }
        return this.windowAll(SlidingEventTimeWindows.of(size, slide));
    }

    public AllWindowedStream<T, GlobalWindow> countWindowAll(long size) {
        return this.windowAll(GlobalWindows.create()).trigger(PurgingTrigger.of(CountTrigger.of(size)));
    }

    public AllWindowedStream<T, GlobalWindow> countWindowAll(long size, long slide) {
        return this.windowAll(GlobalWindows.create()).evictor(CountEvictor.of(size)).trigger(CountTrigger.of(slide));
    }

    @PublicEvolving
    public <W extends Window> AllWindowedStream<T, W> windowAll(WindowAssigner<? super T, W> assigner) {
        return new AllWindowedStream<T, W>(this, assigner);
    }

    @Deprecated
    public SingleOutputStreamOperator<T> assignTimestamps(TimestampExtractor<T> extractor) {
        int inputParallelism = this.getTransformation().getParallelism();
        ExtractTimestampsOperator<T> operator = new ExtractTimestampsOperator<T>(this.clean(extractor));
        return this.transform("ExtractTimestamps", this.getTransformation().getOutputType(), operator).setParallelism(inputParallelism);
    }

    public SingleOutputStreamOperator<T> assignTimestampsAndWatermarks(AssignerWithPeriodicWatermarks<T> timestampAndWatermarkAssigner) {
        int inputParallelism = this.getTransformation().getParallelism();
        AssignerWithPeriodicWatermarks<T> cleanedAssigner = this.clean(timestampAndWatermarkAssigner);
        TimestampsAndPeriodicWatermarksOperator<T> operator = new TimestampsAndPeriodicWatermarksOperator<T>(cleanedAssigner);
        return this.transform("Timestamps/Watermarks", this.getTransformation().getOutputType(), operator).setParallelism(inputParallelism);
    }

    public SingleOutputStreamOperator<T> assignTimestampsAndWatermarks(AssignerWithPunctuatedWatermarks<T> timestampAndWatermarkAssigner) {
        int inputParallelism = this.getTransformation().getParallelism();
        AssignerWithPunctuatedWatermarks<T> cleanedAssigner = this.clean(timestampAndWatermarkAssigner);
        TimestampsAndPunctuatedWatermarksOperator<T> operator = new TimestampsAndPunctuatedWatermarksOperator<T>(cleanedAssigner);
        return this.transform("Timestamps/Watermarks", this.getTransformation().getOutputType(), operator).setParallelism(inputParallelism);
    }

    @PublicEvolving
    public DataStreamSink<T> print() {
        PrintSinkFunction printFunction = new PrintSinkFunction();
        return this.addSink(printFunction);
    }

    @PublicEvolving
    public DataStreamSink<T> printToErr() {
        PrintSinkFunction printFunction = new PrintSinkFunction(true);
        return this.addSink(printFunction);
    }

    @PublicEvolving
    public DataStreamSink<T> writeAsText(String path) {
        return this.writeUsingOutputFormat((OutputFormat<T>)new TextOutputFormat(new Path(path)));
    }

    @PublicEvolving
    public DataStreamSink<T> writeAsText(String path, FileSystem.WriteMode writeMode) {
        TextOutputFormat tof = new TextOutputFormat(new Path(path));
        tof.setWriteMode(writeMode);
        return this.writeUsingOutputFormat((OutputFormat<T>)tof);
    }

    @PublicEvolving
    public DataStreamSink<T> writeAsCsv(String path) {
        return this.writeAsCsv(path, null, "\n", CsvOutputFormat.DEFAULT_FIELD_DELIMITER);
    }

    @PublicEvolving
    public DataStreamSink<T> writeAsCsv(String path, FileSystem.WriteMode writeMode) {
        return this.writeAsCsv(path, writeMode, "\n", CsvOutputFormat.DEFAULT_FIELD_DELIMITER);
    }

    @PublicEvolving
    public <X extends Tuple> DataStreamSink<T> writeAsCsv(String path, FileSystem.WriteMode writeMode, String rowDelimiter, String fieldDelimiter) {
        Preconditions.checkArgument((boolean)this.getType().isTupleType(), (Object)"The writeAsCsv() method can only be used on data streams of tuples.");
        CsvOutputFormat of = new CsvOutputFormat(new Path(path), rowDelimiter, fieldDelimiter);
        if (writeMode != null) {
            of.setWriteMode(writeMode);
        }
        return this.writeUsingOutputFormat((OutputFormat<T>)of);
    }

    @PublicEvolving
    public DataStreamSink<T> writeToSocket(String hostName, int port, SerializationSchema<T> schema) {
        DataStreamSink<T> returnStream = this.addSink(new SocketClientSink<T>(hostName, port, schema, 0));
        returnStream.setParallelism(1);
        return returnStream;
    }

    @PublicEvolving
    public DataStreamSink<T> writeUsingOutputFormat(OutputFormat<T> format) {
        return this.addSink(new OutputFormatSinkFunction<T>(format));
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> transform(String operatorName, TypeInformation<R> outTypeInfo, OneInputStreamOperator<T, R> operator) {
        this.transformation.getOutputType();
        OneInputTransformation<T, R> resultTransform = new OneInputTransformation<T, R>(this.transformation, operatorName, operator, outTypeInfo, this.environment.getParallelism());
        SingleOutputStreamOperator returnStream = new SingleOutputStreamOperator(this.environment, resultTransform);
        this.getExecutionEnvironment().addOperator(resultTransform);
        return returnStream;
    }

    protected DataStream<T> setConnectionType(StreamPartitioner<T> partitioner) {
        return new DataStream<T>(this.getExecutionEnvironment(), new PartitionTransformation<T>(this.getTransformation(), partitioner));
    }

    public DataStreamSink<T> addSink(SinkFunction<T> sinkFunction) {
        this.transformation.getOutputType();
        if (sinkFunction instanceof InputTypeConfigurable) {
            ((InputTypeConfigurable)sinkFunction).setInputType(this.getType(), this.getExecutionConfig());
        }
        StreamSink<T> sinkOperator = new StreamSink<T>(this.clean(sinkFunction));
        DataStreamSink<T> sink = new DataStreamSink<T>(this, sinkOperator);
        this.getExecutionEnvironment().addOperator(sink.getTransformation());
        return sink;
    }

    @Internal
    public StreamTransformation<T> getTransformation() {
        return this.transformation;
    }
}

