/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators;

import org.apache.flink.streaming.api.functions.TimestampExtractor;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Deprecated
public class ExtractTimestampsOperator<T>
extends AbstractUdfStreamOperator<T, TimestampExtractor<T>>
implements OneInputStreamOperator<T, T>,
Triggerable {
    private static final long serialVersionUID = 1L;
    private transient long watermarkInterval;
    private transient long currentWatermark;

    public ExtractTimestampsOperator(TimestampExtractor<T> extractor) {
        super(extractor);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.watermarkInterval = this.getExecutionConfig().getAutoWatermarkInterval();
        if (this.watermarkInterval > 0L) {
            this.registerTimer(System.currentTimeMillis() + this.watermarkInterval, this);
        }
        this.currentWatermark = Long.MIN_VALUE;
    }

    @Override
    public void processElement(StreamRecord<T> element) throws Exception {
        long newTimestamp = ((TimestampExtractor)this.userFunction).extractTimestamp(element.getValue(), element.getTimestamp());
        this.output.collect(element.replace(element.getValue(), newTimestamp));
        long watermark = ((TimestampExtractor)this.userFunction).extractWatermark(element.getValue(), newTimestamp);
        if (watermark > this.currentWatermark) {
            this.currentWatermark = watermark;
            this.output.emitWatermark(new Watermark(this.currentWatermark));
        }
    }

    @Override
    public void trigger(long timestamp) throws Exception {
        this.registerTimer(System.currentTimeMillis() + this.watermarkInterval, this);
        long newWatermark = ((TimestampExtractor)this.userFunction).getCurrentWatermark();
        if (newWatermark > this.currentWatermark) {
            this.currentWatermark = newWatermark;
            this.output.emitWatermark(new Watermark(this.currentWatermark));
        }
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        if (mark.getTimestamp() == Long.MAX_VALUE && mark.getTimestamp() > this.currentWatermark) {
            this.currentWatermark = Long.MAX_VALUE;
            this.output.emitWatermark(mark);
        }
    }
}

