/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.parser;

import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.parser.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;

public final class SQLParserExecutor {
    private final String databaseTypeName;
    private final String sql;

    public ParseASTNode execute() {
        ParseASTNode result = this.towPhaseParse();
        if (result.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException(String.format("Unsupported SQL of `%s`", this.sql), new Object[0]);
        }
        return result;
    }

    private ParseASTNode towPhaseParse() {
        SQLParser sqlParser = SQLParserFactory.newInstance(this.databaseTypeName, this.sql);
        try {
            ((Parser)sqlParser).setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return (ParseASTNode)sqlParser.parse();
        }
        catch (ParseCancellationException ex) {
            ((Parser)sqlParser).reset();
            ((Parser)sqlParser).setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.LL);
            return (ParseASTNode)sqlParser.parse();
        }
    }

    @Generated
    public SQLParserExecutor(String databaseTypeName, String sql) {
        this.databaseTypeName = databaseTypeName;
        this.sql = sql;
    }
}

