/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.Arrays;

public class KeyTransRecipientId
extends RecipientId {
    private byte[] subjectKeyId;
    private X500Name issuer;
    private BigInteger serialNumber;

    public KeyTransRecipientId(byte[] byArray) {
        super(0);
        super.setSubjectKeyIdentifier(new DEROctetString(byArray).getDEREncoded());
        this.subjectKeyId = byArray;
    }

    public KeyTransRecipientId(X500Name x500Name, BigInteger bigInteger) {
        super(0);
        this.issuer = x500Name;
        this.serialNumber = bigInteger;
        try {
            this.setIssuer(x500Name.getDEREncoded());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid issuer: " + iOException.getMessage());
        }
        this.setSerialNumber(bigInteger);
    }

    public int hashCode() {
        int n = Arrays.hashCode((byte[])this.subjectKeyId);
        if (this.serialNumber != null) {
            n ^= this.serialNumber.hashCode();
        }
        if (this.issuer != null) {
            n ^= this.issuer.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyTransRecipientId)) {
            return false;
        }
        KeyTransRecipientId keyTransRecipientId = (KeyTransRecipientId)object;
        return Arrays.areEqual((byte[])this.subjectKeyId, (byte[])keyTransRecipientId.subjectKeyId) && this.equalsObj(this.serialNumber, keyTransRecipientId.serialNumber) && this.equalsObj(this.issuer, keyTransRecipientId.issuer);
    }

    private boolean equalsObj(Object object, Object object2) {
        return object != null ? object.equals(object2) : object2 == null;
    }

    public boolean match(Object object) {
        if (object instanceof X509CertificateHolder) {
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
            if (this.getSerialNumber() != null) {
                IssuerAndSerialNumber issuerAndSerialNumber = x509CertificateHolder.getIssuerAndSerialNumber();
                return issuerAndSerialNumber.getName().equals((Object)this.issuer) && issuerAndSerialNumber.getSerialNumber().getValue().equals(this.getSerialNumber());
            }
            if (this.getSubjectKeyIdentifier() != null) {
                X509Extension x509Extension = x509CertificateHolder.getExtension(X509Extension.subjectKeyIdentifier);
                if (x509Extension == null) {
                    SHA1Digest sHA1Digest = new SHA1Digest();
                    byte[] byArray = new byte[sHA1Digest.getDigestSize()];
                    byte[] byArray2 = x509CertificateHolder.getSubjectPublicKeyInfo().getDEREncoded();
                    sHA1Digest.update(byArray2, 0, byArray2.length);
                    sHA1Digest.doFinal(byArray, 0);
                    return Arrays.areEqual((byte[])this.subjectKeyId, (byte[])byArray);
                }
                byte[] byArray = ASN1OctetString.getInstance((Object)x509Extension.getParsedValue()).getOctets();
                return Arrays.areEqual((byte[])this.subjectKeyId, (byte[])byArray);
            }
        } else {
            if (object instanceof byte[]) {
                return Arrays.areEqual((byte[])this.subjectKeyId, (byte[])((byte[])object));
            }
            if (object instanceof KeyTransRecipientInformation) {
                return ((KeyTransRecipientInformation)object).getRID().equals(this);
            }
        }
        return false;
    }
}

