/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.utils;

import java.util.Date;
import org.hswebframework.utils.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateTimeUtils {
    public static final String YEAR = "yyyy";
    public static final String YEAR_MONTH = "yyyy-MM";
    public static final String YEAR_MONTH_DAY = "yyyy-MM-dd";
    public static final String YEAR_MONTH_DAY_SIMPLE = "yyyyMMdd";
    public static final String YEAR_MONTH_DAY_HOUR = "yyyy-MM-dd HH";
    public static final String YEAR_MONTH_DAY_HOUR_CN = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6";
    public static final String YEAR_MONTH_DAY_HOUR_MINUTE = "yyyy-MM-dd HH:mm";
    public static final String YEAR_MONTH_DAY_HOUR_MINUTE_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_SIMPLE = "yyyyMMddHHmmss";
    public static final String HOUR_MINUTE_SECOND = "HH:mm:ss";
    public static final String HOUR_MINUTE = "HH:mm";
    public static final String MONTH_DAY = "M.d";
    private static final int DAY_SECOND = 86400;
    private static final int HOUR_SECOND = 3600;
    private static final int MINUTE_SECOND = 60;
    public static final String REG_EXP_DATE = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))\\s+([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        return new DateTime((Object)date).toString(pattern);
    }

    public static Date formatDateString(String dateString, String pattern) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)pattern);
            return dateTimeFormatter.parseDateTime(dateString).toDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDayHourMinuteSecond(int second) {
        int minutes;
        int hours;
        if (second == 0) {
            return "0\u79d2";
        }
        StringBuilder sb = new StringBuilder();
        int days = second / 86400;
        if (days > 0) {
            sb.append(days);
            sb.append("\u5929");
            second -= days * 86400;
        }
        if ((hours = second / 3600) > 0) {
            sb.append(hours);
            sb.append("\u5c0f\u65f6");
            second -= hours * 3600;
        }
        if ((minutes = second / 60) > 0) {
            sb.append(minutes);
            sb.append("\u5206\u949f");
            second -= minutes * 60;
        }
        if (second > 0) {
            sb.append(second);
            sb.append("\u79d2");
        }
        return sb.toString();
    }

    public static String getDayHourMinute(int second) {
        int minutes;
        int hours;
        if (second == 0) {
            return "0\u5206\u949f";
        }
        StringBuilder sb = new StringBuilder();
        int days = second / 86400;
        if (days > 0) {
            sb.append(days);
            sb.append("\u5929");
            second -= days * 86400;
        }
        if ((hours = second / 3600) > 0) {
            sb.append(hours);
            sb.append("\u5c0f\u65f6");
            second -= hours * 3600;
        }
        if ((minutes = second / 60) > 0) {
            sb.append(minutes);
            sb.append("\u5206\u949f");
        }
        return sb.toString();
    }

    public static DateTime getDateOnly(DateTime dateTime) {
        return new DateTime((Object)dateTime.toString(YEAR_MONTH_DAY));
    }

    public static Date[] getMondayAndNextMonday() {
        DateTime dateTime = DateTimeUtils.getDateOnly(new DateTime());
        DateTime monday = dateTime.dayOfWeek().withMinimumValue();
        DateTime nextMonday = monday.plusDays(7);
        return new Date[]{monday.toDate(), nextMonday.toDate()};
    }

    public static Date[] getMondayAndSunday(DateTime dateTime) {
        dateTime = DateTimeUtils.getDateOnly(dateTime);
        DateTime monday = dateTime.dayOfWeek().withMinimumValue();
        DateTime sunday = monday.plusDays(6);
        return new Date[]{monday.toDate(), sunday.toDate()};
    }

    public static int compareDaysWithNow(Date date) {
        return Days.daysBetween((ReadableInstant)new DateTime(), (ReadableInstant)new DateTime((Object)date)).getDays();
    }

    public static int compareDaysWithToday(Date date) {
        DateTime today = new DateTime();
        today = new DateTime(today.getYear(), today.getMonthOfYear(), today.getDayOfMonth(), 0, 0, 0, 0);
        DateTime compareDay = new DateTime((Object)date);
        compareDay = new DateTime(compareDay.getYear(), compareDay.getMonthOfYear(), compareDay.getDayOfMonth(), 0, 0, 0, 0);
        return Days.daysBetween((ReadableInstant)today, (ReadableInstant)compareDay).getDays();
    }

    public static int compareDaysWithDay(Date a, Date b) {
        DateTime today = new DateTime((Object)b);
        today = new DateTime(today.getYear(), today.getMonthOfYear(), today.getDayOfMonth(), 0, 0, 0, 0);
        DateTime compareDay = new DateTime((Object)a);
        compareDay = new DateTime(compareDay.getYear(), compareDay.getMonthOfYear(), compareDay.getDayOfMonth(), 0, 0, 0, 0);
        return Days.daysBetween((ReadableInstant)today, (ReadableInstant)compareDay).getDays();
    }

    public static boolean compareDateIgnoreMillisecond(Date date, Date compareDate) {
        if (date == null && compareDate == null) {
            return true;
        }
        if (date == null && compareDate != null) {
            return false;
        }
        if (date != null && compareDate == null) {
            return false;
        }
        return date.getTime() / 1000L == compareDate.getTime() / 1000L;
    }

    public static int getDay(int second) {
        return second / 86400;
    }

    public static String getCompareWithTodayDateString(Date date) {
        int days = Math.abs(DateTimeUtils.compareDaysWithToday(date));
        String dateString = "";
        if (days == 0) {
            dateString = "\u4eca\u5929";
        } else if (days == 1) {
            dateString = "\u6628\u5929";
        } else if (days == 2) {
            dateString = "2\u5929\u524d";
        } else if (days == 3) {
            dateString = "3\u5929\u524d";
        } else if (days == 4) {
            dateString = "4\u5929\u524d";
        } else if (days == 5) {
            dateString = "5\u5929\u524d";
        } else if (days == 6) {
            dateString = "6\u5929\u524d";
        } else if (days > 6 && days <= 14) {
            dateString = "1\u5468\u524d";
        } else if (days > 14 && days <= 21) {
            dateString = "2\u5468\u524d";
        } else if (days > 21 && days <= 30) {
            dateString = "3\u5468\u524d";
        } else if (days > 30) {
            dateString = "1\u6708\u524d";
        } else if (days > 365) {
            dateString = "1\u5e74\u524d";
        } else if (days > 1095) {
            dateString = "3\u5e74\u524d";
        }
        return dateString;
    }

    public static int compareMinutes(Date now, Date compareDate) {
        return (int)(now.getTime() - compareDate.getTime()) / 60000;
    }

    public static int getDayOfMonth(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.getDayOfMonth();
    }

    public static int getDateOfMonth(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.dayOfMonth().getMaximumValue();
    }

    public static int compareYear(Date date) {
        DateTime btd = new DateTime((Object)date);
        DateTime nowDate = new DateTime();
        int year = 0;
        if (nowDate.getMonthOfYear() > btd.getMonthOfYear()) {
            year = nowDate.getYear() - btd.getYear();
        } else if (nowDate.getMonthOfYear() < btd.getMonthOfYear()) {
            year = nowDate.getYear() - btd.getYear() - 1;
        } else if (nowDate.getMonthOfYear() == btd.getMonthOfYear()) {
            year = nowDate.getDayOfMonth() >= btd.getDayOfMonth() ? nowDate.getYear() - btd.getYear() : nowDate.getYear() - btd.getYear() - 1;
        }
        return year;
    }

    public static String compareDaysWithDate(Date date, Date date2) {
        StringBuilder msg = new StringBuilder();
        int minutes = (int)Math.abs((date.getTime() - date2.getTime()) / 60000L);
        if (minutes / 60 > 0 && minutes / 60 / 24 <= 0) {
            msg.append(minutes / 60 + "\u5c0f\u65f6");
        }
        if (minutes / 60 / 24 > 0) {
            msg.append(minutes / 60 / 24 + "\u5929");
            msg.append(minutes / 60 % 24 + "\u5c0f\u65f6");
        }
        return msg.toString();
    }

    public static Date formatUnknownString2Date(String dateString) {
        try {
            if (StringUtils.isNullOrEmpty(dateString)) {
                return null;
            }
            dateString = dateString.replace("T", " ");
            String hms = "00:00:00";
            if ((dateString = dateString.trim()).contains(" ")) {
                hms = dateString.substring(dateString.indexOf(" ") + 1, dateString.length());
                dateString = dateString.substring(0, dateString.indexOf(" "));
                hms = hms.replace("\uff1a", ":");
                hms = hms.replace("\u65f6", ":");
                hms = hms.replace("\u5206", ":");
                hms = hms.replace("\u79d2", ":");
                hms = hms.replace("-", ":");
                if ((hms = hms.replace("\uff0d", ":")).endsWith(":")) {
                    hms = hms.substring(0, hms.length() - 1);
                }
                if (hms.split(":").length == 1) {
                    hms = hms + ":00:00";
                }
                if (hms.split(":").length == 2) {
                    hms = hms + ":00";
                }
            }
            String[] hmsarr = hms.split(":");
            dateString = dateString.replace(".", "-");
            dateString = dateString.replace("/", "-");
            dateString = dateString.replace("\uff0d", "-");
            dateString = dateString.replace("\u5e74", "-");
            dateString = dateString.replace("\u6708", "-");
            dateString = dateString.replace("\u65e5", "");
            String[] ymd = dateString.split("-");
            String yearStr = ymd[0];
            String monthStr = ymd.length > 1 ? ymd[1] : "";
            String dateStr = ymd.length > 2 ? ymd[2] : "";
            monthStr = monthStr == "" ? Integer.toString(1) : monthStr;
            dateStr = dateStr == "" ? Integer.toString(1) : dateStr;
            String dtr = yearStr + "-" + monthStr + "-" + dateStr + " " + hms;
            if (!dtr.matches(REG_EXP_DATE)) {
                return null;
            }
            return new DateTime(Integer.parseInt(yearStr.trim()), Integer.parseInt(monthStr.trim()), Integer.parseInt(dateStr.trim()), Integer.parseInt(hmsarr[0].trim()), Integer.parseInt(hmsarr[1].trim()), Integer.parseInt(hmsarr[2].trim()), 0).toDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date[] formatDatesByString(String dateString, String spaceChar, String splitChar) {
        if (spaceChar.equals(splitChar)) {
            return null;
        }
        String[] dateStrs = dateString.split(splitChar);
        Date[] dates = new Date[dateStrs.length];
        int size = dateStrs.length;
        for (int i = 0; i < size; ++i) {
            dates[i] = DateTimeUtils.formatUnknownString2Date(dateStrs[i]);
        }
        return dates;
    }

    public static Date identityCard2Date(String identityCard) {
        try {
            if (identityCard.length() == 18) {
                String dateStr = identityCard.substring(6, 14);
                return DateTimeUtils.formatDateString(dateStr, YEAR_MONTH_DAY_SIMPLE);
            }
            if (identityCard.length() == 15) {
                String dateStr = identityCard.substring(6, 12);
                return DateTimeUtils.formatDateString(dateStr, "yyMMdd");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean validDate(String str) {
        try {
            Date date = DateTimeUtils.formatUnknownString2Date(str);
            return date != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

