/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.logging.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.hswebframework.web.aop.MethodInterceptorHolder;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.logging.LoggerDefine;
import org.hswebframework.web.logging.aop.AccessLoggerParser;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;

public class ResourceAccessLoggerParser
implements AccessLoggerParser {
    Set<Class<? extends Annotation>> annotations = new HashSet<Class>(Arrays.asList(Resource.class, ResourceAction.class));

    @Override
    public boolean support(Class clazz, Method method) {
        Set a1 = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, this.annotations);
        Set a2 = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)clazz, this.annotations);
        return !a1.isEmpty() || !a2.isEmpty();
    }

    @Override
    public LoggerDefine parse(MethodInterceptorHolder holder) {
        Set a1 = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)holder.getMethod(), this.annotations);
        Set a2 = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)ClassUtils.getUserClass((Object)holder.getTarget()), this.annotations);
        LoggerDefine define = new LoggerDefine();
        Stream.concat(a1.stream(), a2.stream()).forEach(ann -> {
            if (ann instanceof ResourceAction) {
                define.setAction(((ResourceAction)ann).name());
            }
            if (ann instanceof Resource) {
                define.setDescribe(((Resource)ann).name());
            }
        });
        return define;
    }
}

