/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.api.crud.entity;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.net.URLCodec;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.TermTypeConditionalSupport;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.Sort;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;

public class TermExpressionParser {
    static final URLCodec urlCodec = new URLCodec();

    public static List<Term> parse(String expression) {
        char[] all;
        expression = urlCodec.decode(expression);
        Query conditional = QueryParamEntity.newQuery();
        NestConditional nest = null;
        char[] buf = new char[128];
        int len = 0;
        int spaceLen = 0;
        char[] currentColumn = null;
        char[] currentValue = null;
        String currentTermType = null;
        String currentType = "and";
        int quotationMarks = 0;
        for (char c : all = expression.toCharArray()) {
            if (c == '\'' || c == '\"') {
                if (quotationMarks != 0) {
                    quotationMarks = 0;
                    continue;
                }
                quotationMarks = (byte)(quotationMarks + 1);
                continue;
            }
            if (c == '(') {
                nest = nest == null ? (currentType.equals("or") ? conditional.orNest() : conditional.nest()) : (currentType.equals("or") ? nest.orNest() : nest.nest());
                len = 0;
                continue;
            }
            if (c == ')') {
                TermTypeConditionalSupport end;
                if (nest == null) continue;
                if (null != currentColumn) {
                    currentValue = Arrays.copyOf(buf, len);
                    nest.accept(new String(currentColumn), TermExpressionParser.convertTermType(currentTermType), (Object)new String(currentValue));
                    currentColumn = null;
                    currentTermType = null;
                }
                nest = (end = nest.end()) instanceof NestConditional ? (NestConditional)end : null;
                len = 0;
                spaceLen = (byte)(spaceLen + 1);
                continue;
            }
            if (c == '=' || c == '>' || c == '<') {
                currentTermType = currentTermType != null ? currentTermType + String.valueOf(c) : String.valueOf(c);
                if (currentColumn == null) {
                    currentColumn = Arrays.copyOf(buf, len);
                }
                spaceLen = (byte)(spaceLen + 1);
                len = 0;
                continue;
            }
            if (c == ' ') {
                if (len == 0) continue;
                if (quotationMarks != 0) {
                    int n = len;
                    len = (byte)(len + 1);
                    buf[n] = c;
                    continue;
                }
                spaceLen = (byte)(spaceLen + 1);
                if (currentColumn == null && (spaceLen == 1 || spaceLen % 5 == 0)) {
                    currentColumn = Arrays.copyOf(buf, len);
                    len = 0;
                    continue;
                }
                if (null != currentColumn) {
                    if (null == currentTermType) {
                        currentTermType = new String(Arrays.copyOf(buf, len));
                        len = 0;
                        continue;
                    }
                    currentValue = Arrays.copyOf(buf, len);
                    if (nest != null) {
                        nest.accept(new String(currentColumn), TermExpressionParser.convertTermType(currentTermType), (Object)new String(currentValue));
                    } else {
                        conditional.accept(new String(currentColumn), TermExpressionParser.convertTermType(currentTermType), (Object)new String(currentValue));
                    }
                    currentColumn = null;
                    currentTermType = null;
                    len = 0;
                    continue;
                }
                if (len == 2 || len == 3) {
                    String type = new String(Arrays.copyOf(buf, len));
                    if (type.equalsIgnoreCase("or")) {
                        currentType = "or";
                        if (nest != null) {
                            nest.or();
                        } else {
                            conditional.or();
                        }
                        len = 0;
                        continue;
                    }
                    if (type.equalsIgnoreCase("and")) {
                        currentType = "and";
                        if (nest != null) {
                            nest.and();
                        } else {
                            conditional.and();
                        }
                        len = 0;
                        continue;
                    }
                    currentColumn = Arrays.copyOf(buf, len);
                    len = 0;
                    spaceLen = (byte)(spaceLen + 1);
                    continue;
                }
                currentColumn = Arrays.copyOf(buf, len);
                len = 0;
                spaceLen = (byte)(spaceLen + 1);
                continue;
            }
            int n = len;
            len = (byte)(len + 1);
            buf[n] = c;
        }
        if (null != currentColumn) {
            currentValue = Arrays.copyOf(buf, len);
            if (nest != null) {
                nest.accept(new String(currentColumn), TermExpressionParser.convertTermType(currentTermType), (Object)new String(currentValue));
            } else {
                conditional.accept(new String(currentColumn), TermExpressionParser.convertTermType(currentTermType), (Object)new String(currentValue));
            }
        }
        return ((QueryParamEntity)conditional.getParam()).getTerms();
    }

    public static List<Sort> parseOrder(String expression) {
        return Stream.of(expression.split("[,]")).map(str -> str.split("[ ]")).map(arr -> {
            Sort sort = new Sort();
            sort.setName(arr[0]);
            if (((String[])arr).length > 1 && "desc".equalsIgnoreCase(arr[1])) {
                sort.desc();
            }
            return sort;
        }).collect(Collectors.toList());
    }

    private static String convertTermType(String termType) {
        if (termType == null) {
            return "eq";
        }
        switch (termType) {
            case "=": {
                return "eq";
            }
            case ">": {
                return "gt";
            }
            case "<": {
                return "lt";
            }
            case ">=": {
                return "gte";
            }
            case "<=": {
                return "lte";
            }
        }
        return termType;
    }
}

