/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.initialize;

import java.util.Map;
import org.hswebframework.web.starter.initialize.CallBack;
import org.hswebframework.web.starter.initialize.DefaultDependencyUpgrader;
import org.hswebframework.web.starter.initialize.Dependency;
import org.hswebframework.web.starter.initialize.DependencyInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDependencyInstaller
implements DependencyInstaller {
    Dependency dependency;
    CallBack installer;
    CallBack upgrader;
    CallBack unInstaller;
    CallBack initializer;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Dependency getDependency() {
        return this.dependency;
    }

    public void doInstall(Map<String, Object> context) {
        if (this.installer != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("install [{}/{}]", (Object)this.dependency.getGroupId(), (Object)this.dependency.getArtifactId());
            }
            this.installer.execute(context);
        }
    }

    public void doInitialize(Map<String, Object> context) {
        if (this.initializer != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("initialize [{}/{}]", (Object)this.dependency.getGroupId(), (Object)this.dependency.getArtifactId());
            }
            this.initializer.execute(context);
        }
    }

    public void doUnInstall(Map<String, Object> context) {
        if (this.unInstaller != null) {
            this.unInstaller.execute(context);
        }
    }

    public void doUpgrade(Map<String, Object> context, Dependency installed) {
        DefaultDependencyUpgrader defaultDependencyUpgrader = new DefaultDependencyUpgrader(installed, this.dependency, context);
        context.put("upgrader", defaultDependencyUpgrader);
        if (this.upgrader != null) {
            this.upgrader.execute(context);
        }
    }

    @Override
    public DependencyInstaller setup(Dependency dependency) {
        this.dependency = dependency;
        return this;
    }

    @Override
    public DependencyInstaller onInstall(CallBack callBack) {
        this.installer = callBack;
        return this;
    }

    @Override
    public DependencyInstaller onUpgrade(CallBack callBack) {
        this.upgrader = callBack;
        return this;
    }

    @Override
    public DependencyInstaller onUninstall(CallBack callBack) {
        this.unInstaller = callBack;
        return this;
    }

    @Override
    public DependencyInstaller onInitialize(CallBack initializeCallBack) {
        this.initializer = initializeCallBack;
        return this;
    }
}

