/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.service;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.SortSupportEntity;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.dictionary.entity.DictionaryEntity;
import org.hswebframework.web.dictionary.entity.DictionaryItemEntity;
import org.hswebframework.web.dictionary.event.ClearDictionaryCacheEvent;
import org.hswebframework.web.dictionary.service.DefaultDictionaryItemService;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDictionaryService
extends GenericReactiveCrudService<DictionaryEntity, String> {
    @Autowired
    private DefaultDictionaryItemService itemService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public Mono<Integer> insert(Publisher<DictionaryEntity> entityPublisher) {
        return super.insert(entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<Integer> insertBatch(Publisher<? extends Collection<DictionaryEntity>> entityPublisher) {
        return super.insertBatch(entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<Integer> updateById(String id, Mono<DictionaryEntity> entityPublisher) {
        return super.updateById((Object)id, entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return super.deleteById(idPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<SaveResult> save(Publisher<DictionaryEntity> entityPublisher) {
        return super.save(entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public ReactiveUpdate<DictionaryEntity> createUpdate() {
        return super.createUpdate().onExecute((ignore, r) -> r.doOnSuccess(l -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of())));
    }

    public ReactiveDelete createDelete() {
        return super.createDelete().onExecute((ignore, r) -> r.doOnSuccess(l -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of())));
    }

    public Mono<DictionaryEntity> findDetailById(String id) {
        return this.findById(Mono.just((Object)id)).zipWith(((ReactiveQuery)this.itemService.createQuery().where(DictionaryItemEntity::getDictId, (Object)id)).fetch().collectList(), (dic, items) -> {
            dic.setItems((List<DictionaryItemEntity>)items);
            return dic;
        });
    }

    public Flux<DictionaryEntity> findAllDetail(QueryParamEntity paramEntity) {
        return ((ReactiveQuery)this.createQuery().setParam((QueryParam)paramEntity)).fetch().collect(Collectors.toMap(GenericEntity::getId, Function.identity())).flatMapMany(dicMap -> this.itemService.createQuery().fetch().groupBy(DictionaryItemEntity::getDictId).flatMap(group -> Mono.justOrEmpty(dicMap.get(group.key())).zipWhen(dict -> group.collectList(), (dict, items) -> {
            items.sort(SortSupportEntity::compareTo);
            dict.setItems((List<DictionaryItemEntity>)items);
            return dict;
        })));
    }
}

