/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.file;

import java.io.File;
import java.util.Date;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="hsweb.file.upload")
public class FileUploadProperties {
    private String staticFilePath = "./static";
    private String staticLocation = "/static";

    public StaticFileInfo createStaticSavePath(String name) {
        String fileName = (String)IDGenerator.SNOW_FLAKE_STRING.generate();
        String filePath = DateFormatter.toString((Date)new Date(), (String)"yyyyMMdd");
        String absPath = this.staticFilePath.concat("/").concat(filePath);
        String suffix = name.contains(".") ? name.substring(name.lastIndexOf(".")) : "";
        new File(absPath).mkdirs();
        StaticFileInfo info = new StaticFileInfo();
        info.location = this.staticLocation + "/" + filePath + "/" + fileName + suffix;
        info.savePath = absPath + "/" + fileName + suffix;
        return info;
    }

    public String getStaticFilePath() {
        return this.staticFilePath;
    }

    public String getStaticLocation() {
        return this.staticLocation;
    }

    public void setStaticFilePath(String staticFilePath) {
        this.staticFilePath = staticFilePath;
    }

    public void setStaticLocation(String staticLocation) {
        this.staticLocation = staticLocation;
    }

    public class StaticFileInfo {
        private String savePath;
        private String location;

        public String getSavePath() {
            return this.savePath;
        }

        public String getLocation() {
            return this.location;
        }

        public void setSavePath(String savePath) {
            this.savePath = savePath;
        }

        public void setLocation(String location) {
            this.location = location;
        }
    }
}

