/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.feature;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.Feature;
import org.jetlinks.reactor.ql.feature.FeatureId;
import reactor.core.publisher.Flux;

public interface FromFeature
extends Feature {
    public Function<ReactorQLContext, Flux<ReactorQLRecord>> createFromMapper(FromItem var1, ReactorQLMetadata var2);

    public static Function<ReactorQLContext, Flux<ReactorQLRecord>> createFromMapperByFrom(FromItem body, final ReactorQLMetadata metadata) {
        if (body == null) {
            return ctx -> ctx.getDataSource(null).map(val -> ReactorQLRecord.newRecord(null, val, ctx));
        }
        final AtomicReference ref = new AtomicReference();
        body.accept((FromItemVisitor)new FromItemVisitorAdapter(){

            public void visit(Table table) {
                ref.set(metadata.getFeatureNow(FeatureId.From.table).createFromMapper((FromItem)table, metadata));
            }

            public void visit(SubSelect subSelect) {
                ref.set(metadata.getFeatureNow(FeatureId.From.subSelect).createFromMapper((FromItem)subSelect, metadata));
            }

            public void visit(ValuesList valuesList) {
                ref.set(metadata.getFeatureNow(FeatureId.From.values).createFromMapper((FromItem)valuesList, metadata));
            }

            public void visit(TableFunction tableFunction) {
                ref.set(metadata.getFeatureNow(FeatureId.From.of(tableFunction.getFunction().getName()), () -> ((TableFunction)tableFunction).toString()).createFromMapper((FromItem)tableFunction, metadata));
            }

            public void visit(ParenthesisFromItem aThis) {
                ref.set(FromFeature.createFromMapperByFrom(aThis.getFromItem(), metadata));
            }
        });
        if (ref.get() == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2:" + body);
        }
        return (Function)ref.get();
    }

    public static Function<ReactorQLContext, Flux<ReactorQLRecord>> createFromMapperByBody(SelectBody body, ReactorQLMetadata metadata) {
        FromItem from = null;
        if (body instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)body;
            from = select.getFromItem();
        }
        return FromFeature.createFromMapperByFrom(from, metadata);
    }
}

