/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.group;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.GroupFeature;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class GroupByBinaryFeature
implements GroupFeature {
    private final String id;
    private final BiFunction<Object, Object, Object> mapper;

    public GroupByBinaryFeature(String type, BiFunction<Object, Object, Object> mapper) {
        this.id = FeatureId.GroupBy.of(type).getId();
        this.mapper = mapper;
    }

    @Override
    public Function<Flux<ReactorQLRecord>, Flux<? extends Flux<ReactorQLRecord>>> createGroupMapper(Expression expression, ReactorQLMetadata metadata) {
        Tuple2<Function<ReactorQLRecord, ? extends Publisher<?>>, Function<ReactorQLRecord, ? extends Publisher<?>>> tuple2 = ValueMapFeature.createBinaryMapper(expression, metadata);
        Function leftMapper = (Function)tuple2.getT1();
        Function rightMapper = (Function)tuple2.getT2();
        return flux -> flux.flatMap(ctx -> Mono.zip((Mono)Mono.from((Publisher)((Publisher)leftMapper.apply(ctx))), (Mono)Mono.from((Publisher)((Publisher)rightMapper.apply(ctx))), this.mapper).zipWith(Mono.just((Object)ctx))).groupBy(Tuple2::getT1, Tuple2::getT2, Integer.MAX_VALUE);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

