/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.group;

import java.time.Duration;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.GroupFeature;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class GroupByIntervalFeature
implements GroupFeature {
    private static final Logger log = LoggerFactory.getLogger(GroupByIntervalFeature.class);
    public static final String ID = FeatureId.GroupBy.interval.getId();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Function<Flux<ReactorQLRecord>, Flux<? extends Flux<ReactorQLRecord>>> createGroupMapper(Expression expression, ReactorQLMetadata metadata) {
        Duration interval;
        net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)expression;
        if (function.getParameters() == null || function.getParameters().getExpressions().isEmpty()) {
            throw new UnsupportedOperationException("interval\u51fd\u6570\u53c2\u6570\u9519\u8bef");
        }
        Expression expr = (Expression)function.getParameters().getExpressions().get(0);
        if (expr instanceof StringValue) {
            interval = CastUtils.parseDuration(((StringValue)expr).getValue());
        } else if (expr instanceof LongValue) {
            interval = Duration.ofMillis(((LongValue)expr).getValue());
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u53c2\u6570:" + expr);
        }
        Duration duration = interval;
        return flux -> flux.window(duration);
    }
}

