/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.group;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.GroupFeature;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class GroupByWindowFeature
implements GroupFeature {
    private static final Logger log = LoggerFactory.getLogger(GroupByWindowFeature.class);
    private static final String ID = FeatureId.GroupBy.of("_window").getId();

    @Override
    public Function<Flux<ReactorQLRecord>, Flux<? extends Flux<ReactorQLRecord>>> createGroupMapper(Expression expression, ReactorQLMetadata metadata) {
        List expressions;
        net.sf.jsqlparser.expression.Function windowFunc = (net.sf.jsqlparser.expression.Function)expression;
        ExpressionList parameters = windowFunc.getParameters();
        if (parameters == null || CollectionUtils.isEmpty((Collection)(expressions = parameters.getExpressions()))) {
            throw new UnsupportedOperationException("\u7a97\u53e3\u51fd\u6570\u5fc5\u987b\u4f20\u5165\u53c2\u6570,\u5982: window('10s') , window(30)");
        }
        try {
            if (expressions.size() == 1) {
                return this.createOneParameter(expressions, metadata);
            }
            if (expressions.size() == 2) {
                return this.createTwoParameter(expressions, metadata);
            }
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u51fd\u6570[ " + expression + " ] : " + e.getMessage(), e);
        }
        throw new UnsupportedOperationException("\u51fd\u6570[ " + expression + " ]\u53c2\u6570\u6570\u91cf\u9519\u8bef,\u6700\u5c0f1,\u6700\u59272.");
    }

    protected Function<Flux<ReactorQLRecord>, Flux<? extends Flux<ReactorQLRecord>>> createOneParameter(List<Expression> expressions, ReactorQLMetadata metadata) {
        Expression expr = expressions.get(0);
        if (expr instanceof LongValue) {
            int val = (int)((LongValue)expr).getValue();
            if (val <= 0) {
                throw new UnsupportedOperationException("\u7a97\u53e3\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0:" + expr);
            }
            return flux -> flux.window(val);
        }
        if (expr instanceof StringValue) {
            Duration duration = CastUtils.parseDuration(((StringValue)expr).getValue());
            if (duration.toMillis() <= 0L) {
                throw new UnsupportedOperationException("\u7a97\u53e3\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0:" + expr);
            }
            return flux -> flux.window(duration);
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7a97\u53e3\u8868\u8fbe\u5f0f:" + expr);
    }

    protected Function<Flux<ReactorQLRecord>, Flux<? extends Flux<ReactorQLRecord>>> createTwoParameter(List<Expression> expressions, ReactorQLMetadata metadata) {
        Expression first = expressions.get(0);
        Expression second = expressions.get(1);
        if (first instanceof LongValue && second instanceof LongValue) {
            int val = (int)((LongValue)first).getValue();
            int secondVal = (int)((LongValue)second).getValue();
            if (val <= 0 || secondVal <= 0) {
                throw new UnsupportedOperationException("\u7a97\u53e3\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0: " + (val <= 0 ? first : second));
            }
            return flux -> flux.window(val, secondVal);
        }
        if (first instanceof StringValue && second instanceof StringValue) {
            Duration windowingTimespan = CastUtils.parseDuration(((StringValue)first).getValue());
            Duration openWindowEvery = CastUtils.parseDuration(((StringValue)second).getValue());
            if (windowingTimespan.toMillis() <= 0L || openWindowEvery.toMillis() <= 0L) {
                throw new UnsupportedOperationException("\u7a97\u53e3\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0: " + (windowingTimespan.toMillis() <= 0L ? first : second));
            }
            return flux -> flux.window(windowingTimespan, openWindowEvery);
        }
        if (first instanceof LongValue && second instanceof StringValue) {
            int max = (int)((LongValue)first).getValue();
            Duration timeout = CastUtils.parseDuration(((StringValue)second).getValue());
            if (timeout.toMillis() <= 0L) {
                throw new UnsupportedOperationException("\u7a97\u53e3\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0: " + second);
            }
            if (max <= 0) {
                throw new UnsupportedOperationException("\u7a97\u53e3\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0: " + first);
            }
            return flux -> flux.windowTimeout(max, timeout);
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u53c2\u6570: " + first + " , " + second);
    }

    @Override
    public String getId() {
        return ID;
    }
}

