/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.rule.engine.api.CompositeLogger;
import org.jetlinks.rule.engine.api.RuleConstants;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.scope.GlobalScope;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.Input;
import org.jetlinks.rule.engine.api.task.Output;
import org.jetlinks.rule.engine.defaults.EventLogger;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class AbstractExecutionContext
implements ExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(AbstractExecutionContext.class);
    private final org.jetlinks.rule.engine.api.Logger logger;
    private ScheduleJob job;
    private final EventBus eventBus;
    private final Input input;
    private final Output output;
    private final Map<String, Output> eventOutputs;
    private final List<Runnable> shutdownListener = new CopyOnWriteArrayList<Runnable>();
    private final GlobalScope globalScope;
    private boolean debug;

    public AbstractExecutionContext(String workerId, ScheduleJob job, EventBus eventBus, org.jetlinks.rule.engine.api.Logger logger, Input input, Output output, Map<String, Output> eventOutputs, GlobalScope globalScope) {
        this.job = job;
        this.eventBus = eventBus;
        this.input = input;
        this.output = output;
        this.eventOutputs = eventOutputs;
        this.logger = CompositeLogger.of(logger, new EventLogger(eventBus, job.getInstanceId(), job.getNodeId(), workerId));
        this.globalScope = globalScope;
    }

    @Override
    public String getInstanceId() {
        return this.job.getInstanceId();
    }

    @Override
    public <T> Mono<T> fireEvent(@Nonnull String event, @Nonnull RuleData data) {
        Mono then = this.eventBus.publish(RuleConstants.Topics.event(this.job.getInstanceId(), this.job.getNodeId(), event), (Object)data).doOnSubscribe(ignore -> log.trace("fire job task [{}] event [{}] ", (Object)this.job, (Object)event)).then(Mono.empty());
        Output output = this.eventOutputs.get(event);
        if (output != null) {
            return output.write((Publisher<RuleData>)Mono.just((Object)data)).then(then);
        }
        return then;
    }

    @Override
    public <T> Mono<T> onError(@Nullable Throwable e, @Nullable RuleData sourceData) {
        return this.fireEvent("error", this.createErrorData(e, sourceData));
    }

    private RuleData createErrorData(Throwable e, RuleData source) {
        HashMap<String, String> obj = new HashMap<String, String>();
        if (e != null) {
            obj.put("type", e.getClass().getSimpleName());
            obj.put("message", e.getMessage());
            obj.put("stack", StringUtils.throwable2String((Throwable)e));
        }
        return this.newRuleData(source == null ? obj : source.newData(obj));
    }

    @Override
    public RuleData newRuleData(Object data) {
        RuleData ruleData = RuleData.create(data);
        ruleData.setHeader("sourceNode", this.getJob().getNodeId());
        return ruleData;
    }

    @Override
    public Mono<Void> shutdown(String code, String message) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("code", code);
        data.put("message", message);
        return this.eventBus.publish(RuleConstants.Topics.shutdown(this.job.getInstanceId(), this.job.getNodeId()), data).then();
    }

    public void doShutdown() {
        for (Runnable runnable : this.shutdownListener) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public void onShutdown(Runnable runnable) {
        this.shutdownListener.add(runnable);
    }

    @Override
    public GlobalScope global() {
        return this.globalScope;
    }

    @Override
    public org.jetlinks.rule.engine.api.Logger getLogger() {
        return this.logger;
    }

    public void setJob(ScheduleJob job) {
        this.job = job;
    }

    @Override
    public ScheduleJob getJob() {
        return this.job;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }
}

