/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults.scope;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetlinks.rule.engine.api.scope.PersistenceScope;
import org.jetlinks.rule.engine.api.scope.ScropeCounter;
import org.jetlinks.rule.engine.defaults.scope.InMemoryScopeCounter;
import reactor.core.publisher.Mono;

public class InMemoryPersistenceScope
implements PersistenceScope {
    private final ConcurrentMap<String, Object> store = new ConcurrentHashMap<String, Object>();
    private final Map<String, ScropeCounter> counter = new ConcurrentHashMap<String, ScropeCounter>();

    @Override
    public Mono<Void> put(String key, Object value) {
        return Mono.fromRunnable(() -> this.store.put(key, value));
    }

    @Override
    public Mono<Void> putAll(Map<String, Object> keyValue) {
        return Mono.fromRunnable(() -> this.store.putAll(keyValue));
    }

    @Override
    public Mono<Map<String, Object>> all(String ... key) {
        return Mono.fromSupplier(() -> {
            if (key.length == 0) {
                return this.store;
            }
            HashMap vals = new HashMap();
            for (String s : key) {
                vals.put(s, this.store.get(s));
            }
            return vals;
        });
    }

    @Override
    public Mono<Object> get(String key) {
        return Mono.fromSupplier(() -> this.store.get(key));
    }

    @Override
    public Mono<Object> remove(String key) {
        return Mono.fromSupplier(() -> this.store.remove(key));
    }

    @Override
    public Mono<Void> clear() {
        return Mono.fromRunnable(this.store::clear);
    }

    @Override
    public ScropeCounter counter(String key) {
        return this.counter.computeIfAbsent(key, k -> new InMemoryScopeCounter());
    }
}

