/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.executor;

import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.jetlinks.rule.engine.api.RuleDataCodec;

public enum PayloadType implements RuleDataCodec.Feature
{
    JSON{

        @Override
        public Object read(ByteBuf byteBuf) {
            return com.alibaba.fastjson.JSON.parse((String)byteBuf.toString(StandardCharsets.UTF_8));
        }

        @Override
        public ByteBuf write(Object data) {
            if (!(data instanceof String)) {
                data = com.alibaba.fastjson.JSON.toJSONString((Object)data);
            }
            return Unpooled.wrappedBuffer((byte[])String.valueOf(data).getBytes());
        }
    }
    ,
    STRING{

        @Override
        public String read(ByteBuf byteBuf) {
            return byteBuf.toString(StandardCharsets.UTF_8);
        }

        @Override
        public ByteBuf write(Object data) {
            if (!(data instanceof String)) {
                data = com.alibaba.fastjson.JSON.toJSONString((Object)data);
            }
            return Unpooled.wrappedBuffer((byte[])String.valueOf(data).getBytes());
        }
    }
    ,
    BINARY{

        public byte[] read(ByteBuf byteBuf) {
            return ByteBufUtil.getBytes((ByteBuf)byteBuf);
        }

        @Override
        public ByteBuf write(Object data) {
            if (data instanceof byte[]) {
                return Unpooled.wrappedBuffer((byte[])((byte[])data));
            }
            return Unpooled.wrappedBuffer((byte[])String.valueOf(data).getBytes());
        }
    }
    ,
    HEX{

        @Override
        public String read(ByteBuf byteBuf) {
            return ByteBufUtil.hexDump((byte[])((byte[])BINARY.read(byteBuf)));
        }

        @Override
        public ByteBuf write(Object data) {
            String hex = data instanceof byte[] ? new String((byte[])data) : (data instanceof char[] ? new String((char[])data) : (data instanceof ByteBuf ? new String(ByteBufUtil.getBytes((ByteBuf)((ByteBuf)data))) : String.valueOf(data)));
            return Unpooled.wrappedBuffer((byte[])ByteBufUtil.decodeHexDump((CharSequence)hex.replace("\n", "").replace(" ", "")));
        }
    };


    public abstract ByteBuf write(Object var1);

    public abstract Object read(ByteBuf var1);

    public String getName() {
        return this.name();
    }

    public String getId() {
        return this.name();
    }
}

