/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.beans.gen.BeanCodeGenException;
import org.joda.beans.gen.BeanData;
import org.joda.beans.gen.BeanParser;
import org.joda.beans.gen.PropertyData;
import org.joda.beans.gen.PropertyGen;
import org.joda.beans.gen.SetterGen;

class PropertyParser {
    private static final Pattern ALIAS_PATTERN = Pattern.compile(".*[ ,(]alias[ ]*[=][ ]*[\"]([a-zA-z_][a-zA-z0-9_]*)[\"].*");
    private static final Pattern GETTER_PATTERN = Pattern.compile(".*[ ,(]get[ ]*[=][ ]*[\"]([a-zA-Z-]*)[\"].*");
    private static final Pattern SETTER_PATTERN = Pattern.compile(".*[ ,(]set[ ]*[=][ ]*[\"]([ !#-~]*)[\"].*");
    private static final Pattern OVERRIDE_GET_PATTERN = Pattern.compile(".*[ ,(]overrideGet[ ]*[=][ ]*(true|false).*");
    private static final Pattern OVERRIDE_SET_PATTERN = Pattern.compile(".*[ ,(]overrideSet[ ]*[=][ ]*(true|false).*");
    private static final Pattern TYPE_PATTERN = Pattern.compile(".*[ ,(]type[ ]*[=][ ]*[\"]([a-zA-Z0-9 ,_<>?.]*)[\"].*");
    private static final Pattern BUILDER_TYPE_PATTERN = Pattern.compile(".*[ ,(]builderType[ ]*[=][ ]*[\"]([a-zA-Z0-9 ,_<>?.]*)[\"].*");
    private static final Pattern EQ_HASH_PATTERN = Pattern.compile(".*[ ,(]equalsHashCodeStyle[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern TO_STR_PATTERN = Pattern.compile(".*[ ,(]toStringStyle[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern VALIDATION_PATTERN = Pattern.compile(".*[ ,(]validate[ ]*[=][ ]*[\"]([a-zA-Z_.]*)[\"].*");
    private final BeanParser beanParser;
    private int propertyIndex;
    private int annotationIndex;
    private int fieldIndex;

    PropertyParser(BeanParser beanParser) {
        this.beanParser = beanParser;
    }

    PropertyGen parse(BeanData beanData, List<String> content, int lineIndex) {
        this.propertyIndex = lineIndex;
        this.annotationIndex = this.parseAnnotationStart(content, lineIndex);
        this.fieldIndex = this.parseCodeIndex(content);
        PropertyData data = new PropertyData(beanData, this.beanParser.getConfig(), lineIndex);
        data.setAlias(this.parseAlias(content));
        data.setGetStyle(this.parseGetStyle(content));
        data.setSetStyle(this.parseSetStyle(content));
        data.setOverrideGet(this.parseOverrideGet(content));
        data.setOverrideSet(this.parseOverrideSet(content));
        data.setTypeStyle(this.parseTypeStyle(content));
        data.setBuilderTypeStyle(this.parseBuilderTypeStyle(content));
        data.setEqualsHashCodeStyle(this.parseEqualsHashCodeStyle(content));
        data.setToStringStyle(this.parseToStringStyle(content));
        data.setValidation(this.parseValidation(content));
        data.setDeprecated(this.parseDeprecated(content));
        data.setFieldName(this.parseFieldName(content));
        data.setPropertyName(this.makePropertyName(data.getFieldName()));
        data.setUpperName(this.makeUpperName(data.getPropertyName()));
        data.setFinal(this.parseFinal(content));
        data.setFieldType(this.parseFieldType(content));
        data.setInitializer(this.parseFieldInitializer(content));
        data.resolveType();
        data.resolveBuilderType();
        data.resolveValidation();
        data.resolveGetterGen(this.beanParser.getFile(), lineIndex);
        data.resolveSetterGen(this.beanParser.getFile(), lineIndex);
        data.resolveCopyGen(this.beanParser.getFile(), lineIndex);
        data.resolveBuilderGen();
        data.resolveEqualsHashCodeStyle(this.beanParser.getFile(), lineIndex);
        data.resolveToStringStyle(this.beanParser.getFile(), lineIndex);
        data.setMetaFieldName(this.beanParser.getFieldPrefix() + data.getPropertyName());
        List<String> comments = this.parseComment(content, data.getPropertyName());
        data.setFirstComment(comments.get(0));
        data.getComments().addAll(comments.subList(1, comments.size()));
        if (beanData.isBeanStyleLightOrMinimal() && beanData.isMutable() && data.getSetterGen() instanceof SetterGen.NoSetterGen) {
            throw new IllegalArgumentException("Light and Minimal style beans do not support final fields when mutable");
        }
        return new PropertyGen(data);
    }

    PropertyGen parseDerived(BeanData beanData, List<String> content, int lineIndex) {
        this.propertyIndex = lineIndex;
        this.annotationIndex = this.parseAnnotationStart(content, lineIndex);
        this.fieldIndex = this.parseCodeIndex(content);
        PropertyData data = new PropertyData(beanData, this.beanParser.getConfig(), lineIndex);
        data.setGetStyle("manual");
        data.setSetStyle("");
        data.setTypeStyle("");
        data.setBuilderTypeStyle("");
        data.setDeprecated(this.parseDeprecated(content));
        data.setPropertyName(this.parseMethodNameAsPropertyName(content));
        data.setUpperName(this.makeUpperName(data.getPropertyName()));
        data.setFieldType(this.parseMethodType(content));
        data.setInitializer(this.parseFieldInitializer(content));
        data.resolveType();
        data.resolveBuilderType();
        data.resolveValidation();
        data.resolveGetterGen(this.beanParser.getFile(), lineIndex);
        data.resolveSetterGen(this.beanParser.getFile(), lineIndex);
        data.resolveCopyGen(this.beanParser.getFile(), lineIndex);
        data.resolveBuilderGen();
        data.setMetaFieldName(this.beanParser.getFieldPrefix() + data.getPropertyName());
        List<String> comments = this.parseComment(content, data.getPropertyName());
        data.setFirstComment(comments.get(0));
        data.getComments().addAll(comments.subList(1, comments.size()));
        return new PropertyGen(data);
    }

    private String makePropertyName(String name) {
        if (name.startsWith(this.beanParser.getFieldPrefix())) {
            return name.substring(this.beanParser.getFieldPrefix().length());
        }
        return name;
    }

    private String makeUpperName(String name) {
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    private int parseAnnotationStart(List<String> content, int lineIndex) {
        if (lineIndex > 0 && content.get(lineIndex - 1).trim().startsWith("@")) {
            return lineIndex - 1;
        }
        return lineIndex;
    }

    private int parseCodeIndex(List<String> content) {
        for (int index = this.propertyIndex; index < content.size(); ++index) {
            String line = content.get(index).trim();
            if (line.startsWith("@") || line.length() == 0 || line.startsWith("//") || index > this.propertyIndex && content.get(index - 1).endsWith(",")) continue;
            return index;
        }
        throw new BeanCodeGenException("Unable to locate field for property at line " + (this.propertyIndex + 1), this.beanParser.getFile(), this.propertyIndex + 1);
    }

    private String parseAlias(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = ALIAS_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private String parseGetStyle(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = GETTER_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseSetStyle(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = SETTER_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private boolean parseOverrideGet(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = OVERRIDE_GET_PATTERN.matcher(line);
        if (matcher.matches()) {
            return "true".equals(matcher.group(1));
        }
        return false;
    }

    private boolean parseOverrideSet(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = OVERRIDE_SET_PATTERN.matcher(line);
        if (matcher.matches()) {
            return "true".equals(matcher.group(1));
        }
        return false;
    }

    private String parseTypeStyle(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = TYPE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseBuilderTypeStyle(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = BUILDER_TYPE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseEqualsHashCodeStyle(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = EQ_HASH_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseToStringStyle(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = TO_STR_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseValidation(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = VALIDATION_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private boolean parseDeprecated(List<String> content) {
        for (int index = this.annotationIndex; index < this.fieldIndex; ++index) {
            String line = content.get(index).trim();
            if (!line.equals("@Deprecated") && !line.startsWith("@Deprecated ")) continue;
            return true;
        }
        return false;
    }

    private String parseFieldName(List<String> content) {
        String line = this.parseFieldDefinition(content);
        String[] parts = line.split(" ");
        String last = parts[parts.length - 1];
        if (last.endsWith(";") && last.length() > 1) {
            return last.substring(0, last.length() - 1);
        }
        throw new BeanCodeGenException("Unable to locate field name at line " + (this.propertyIndex + 1), this.beanParser.getFile(), this.propertyIndex + 1);
    }

    private boolean parseFinal(List<String> content) {
        String line = this.parseFieldDefinition(content);
        String[] parts = line.split(" ");
        if (parts.length < 2) {
            throw new BeanCodeGenException("Unable to locate field type at line " + (this.propertyIndex + 1), this.beanParser.getFile(), this.propertyIndex + 1);
        }
        return parts[0].equals("final") || parts[1].equals("final") || parts.length >= 3 && parts[2].equals("final");
    }

    private String parseFieldType(List<String> content) {
        String line = this.parseFieldDefinition(content);
        String[] parts = line.split(" ");
        if (parts.length < 2) {
            throw new BeanCodeGenException("Unable to locate field type at line " + (this.propertyIndex + 1), this.beanParser.getFile(), this.propertyIndex + 1);
        }
        int partsPos = parts.length - 2;
        String type = parts[partsPos];
        while (true) {
            int open = 0;
            int openPos = 0;
            int close = 0;
            int closePos = 0;
            while ((openPos = type.indexOf(60, openPos)) >= 0) {
                ++open;
                ++openPos;
            }
            while ((closePos = type.indexOf(62, closePos)) >= 0) {
                ++close;
                ++closePos;
            }
            if (open == close) break;
            if (partsPos == 0) {
                throw new BeanCodeGenException("Unable to locate field type at line " + (this.propertyIndex + 1) + ", mismatched generics", this.beanParser.getFile(), this.propertyIndex + 1);
            }
            type = parts[--partsPos] + " " + type;
        }
        return type;
    }

    private String parseFieldDefinition(List<String> content) {
        String line = content.get(this.fieldIndex).trim();
        if (line.contains("//")) {
            line = line.substring(0, line.indexOf("//")).trim();
        }
        if (line.contains("=")) {
            line = line.substring(0, line.indexOf("=")).trim() + ";";
        }
        return line;
    }

    private String parseFieldInitializer(List<String> content) {
        String line = content.get(this.fieldIndex).trim();
        if (line.contains("//")) {
            line = line.substring(0, line.indexOf("//")).trim();
        }
        if (line.contains(" = ")) {
            if (!(line = line.substring(line.indexOf(" = ") + 3).trim()).endsWith(";")) {
                throw new BeanCodeGenException("Field line does not end with semi-colon", this.beanParser.getFile(), this.fieldIndex);
            }
            return line.substring(0, line.length() - 1).trim();
        }
        return "";
    }

    private String parseMethodNameAsPropertyName(List<String> content) {
        String name = this.parseMethodDefinition(content)[1];
        if (name.length() == 0 || !Character.isUpperCase(name.charAt(0))) {
            throw new BeanCodeGenException("@DerivedProperty method name invalid: '" + name + "'", this.beanParser.getFile(), this.fieldIndex);
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private String parseMethodType(List<String> content) {
        String[] parts = this.parseMethodDefinition(content);
        return parts[0];
    }

    private String[] parseMethodDefinition(List<String> content) {
        String line = content.get(this.fieldIndex).trim();
        if (line.startsWith("public ")) {
            line = line.substring(7).trim();
        } else if (line.startsWith("private ")) {
            line = line.substring(8).trim();
        } else if (line.startsWith("protected ")) {
            line = line.substring(10).trim();
        }
        String lineEnd = "() {";
        if (line.startsWith("abstract ")) {
            line = line.substring(9).trim();
            lineEnd = "();";
        } else if (line.startsWith("final ")) {
            line = line.substring(6).trim();
        } else if (line.startsWith("static ")) {
            throw new BeanCodeGenException("@DerivedProperty method cannot be static", this.beanParser.getFile(), this.fieldIndex);
        }
        int getIndex = line.indexOf(" get");
        if (getIndex < 0) {
            throw new BeanCodeGenException("@DerivedProperty method must start with 'get'", this.beanParser.getFile(), this.fieldIndex);
        }
        if (!line.endsWith(lineEnd)) {
            throw new BeanCodeGenException("@DerivedProperty method must end with '" + lineEnd + "'", this.beanParser.getFile(), this.fieldIndex);
        }
        line = line.substring(0, line.length() - lineEnd.length());
        String[] split = new String[]{line.substring(0, getIndex).trim(), line.substring(getIndex + 4).trim()};
        return split;
    }

    private List<String> parseComment(List<String> content, String propertyName) {
        int endPos;
        int startPos;
        String comment;
        ArrayList<String> comments = new ArrayList<String>();
        String commentEnd = content.get(this.annotationIndex - 1).trim();
        if (commentEnd.equals("*/")) {
            int startCommentIndex = -1;
            for (int index = this.annotationIndex - 1; index >= 0; --index) {
                String line = content.get(index).trim();
                if (!line.equals("/**")) continue;
                startCommentIndex = index + 1;
                break;
            }
            if (startCommentIndex == -1) {
                throw new BeanCodeGenException("Unable to locate comment start at line " + this.annotationIndex, this.beanParser.getFile(), this.annotationIndex);
            }
            if (startCommentIndex < this.annotationIndex - 1) {
                for (int i = startCommentIndex; i < this.annotationIndex - 1; ++i) {
                    String commentLine = content.get(i).trim();
                    if (commentLine.startsWith("*")) {
                        commentLine = commentLine.substring(1).trim();
                    }
                    if (commentLine.startsWith("@return") || commentLine.startsWith("@param") || commentLine.startsWith("@throws") || commentLine.startsWith("@exception")) continue;
                    comments.add(commentLine);
                }
                String firstLine = (String)comments.get(0);
                if (firstLine.length() > 0) {
                    comments.set(0, firstLine.substring(0, 1).toLowerCase(Locale.ENGLISH) + firstLine.substring(1));
                } else {
                    comments.remove(0);
                }
            }
        } else if (commentEnd.startsWith("/**") && commentEnd.endsWith("*/") && (comment = commentEnd.substring(startPos = commentEnd.indexOf("/**") + 3, endPos = commentEnd.lastIndexOf("*/")).trim()).length() > 0) {
            comments.add(comment.substring(0, 1).toLowerCase(Locale.ENGLISH) + comment.substring(1));
        }
        if (comments.size() == 0) {
            comments.add("the " + propertyName + ".");
        }
        return comments;
    }
}

