/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.reflection;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.impl.BasicBeanBuilder;
import org.joda.beans.impl.reflection.ReflectiveMetaProperty;

public final class ReflectiveMetaBean<T extends Bean>
implements TypedMetaBean<T> {
    private final Class<T> beanType;
    private final Map<String, MetaProperty<?>> metaPropertyMap;

    public static <B extends Bean> ReflectiveMetaBean<B> of(Class<B> beanClass, String ... propertyNames) {
        return new ReflectiveMetaBean<B>(beanClass, propertyNames);
    }

    private ReflectiveMetaBean(Class<T> beanType, String[] propertyNames) {
        if (beanType == null) {
            throw new NullPointerException("Bean class must not be null");
        }
        if (propertyNames == null) {
            throw new NullPointerException("Property names must not be null");
        }
        this.beanType = beanType;
        LinkedHashMap map = new LinkedHashMap();
        for (String name : propertyNames) {
            map.put(name, new ReflectiveMetaProperty(this, beanType, name));
        }
        this.metaPropertyMap = Collections.unmodifiableMap(map);
    }

    @Override
    public boolean isBuildable() {
        try {
            this.beanType.newInstance();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public BeanBuilder<T> builder() {
        try {
            Bean bean = (Bean)this.beanType.newInstance();
            return new BasicBeanBuilder<Bean>(bean);
        }
        catch (InstantiationException ex) {
            throw new UnsupportedOperationException("Bean cannot be created: " + this.beanName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Bean cannot be created: " + this.beanName(), ex);
        }
    }

    @Override
    public Class<T> beanType() {
        return this.beanType;
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
        return this.metaPropertyMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReflectiveMetaBean) {
            ReflectiveMetaBean other = (ReflectiveMetaBean)obj;
            return this.beanType.equals(other.beanType);
        }
        return false;
    }

    public int hashCode() {
        return this.beanType.hashCode() + 3;
    }

    public String toString() {
        return "MetaBean:" + this.beanName();
    }
}

