/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.map;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerDeserializer;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerIteratorFactory;
import org.joda.beans.ser.SerOptional;

public class JodaBeanSimpleMapReader {
    private final JodaBeanSer settings;

    public JodaBeanSimpleMapReader(JodaBeanSer settings) {
        JodaBeanUtils.notNull(settings, "settings");
        this.settings = settings;
    }

    public <T> T read(Map<String, Object> input, Class<T> rootType) {
        JodaBeanUtils.notNull(input, "input");
        JodaBeanUtils.notNull(rootType, "rootType");
        try {
            return this.parseRoot(input, rootType);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> T parseRoot(Map<String, Object> input, Class<T> declaredType) throws Exception {
        Object parsed = this.parseBean(input, declaredType);
        return declaredType.cast(parsed);
    }

    private Object parseBean(Map<String, Object> input, Class<?> beanType) throws Exception {
        String propName = "";
        try {
            SerDeserializer deser = this.settings.getDeserializers().findDeserializer(beanType);
            MetaBean metaBean = deser.findMetaBean(beanType);
            BeanBuilder<?> builder = deser.createBuilder(beanType, metaBean);
            for (Map.Entry<String, Object> entry : input.entrySet()) {
                propName = entry.getKey();
                MetaProperty<?> metaProp = deser.findMetaProperty(beanType, metaBean, propName);
                if (metaProp != null && !metaProp.style().isDerived()) {
                    Object value = this.parseObject(entry.getValue(), SerOptional.extractType(metaProp, beanType), metaProp, beanType, null);
                    deser.setValue(builder, metaProp, SerOptional.wrapValue(metaProp, beanType, value));
                }
                propName = "";
            }
            return deser.build(beanType, builder);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error parsing bean: " + beanType.getName() + "::" + propName + ", " + ex.getMessage(), ex);
        }
    }

    private Object parseObject(Object input, Class<?> declaredType, MetaProperty<?> metaProp, Class<?> beanType, SerIterable parentIterable) throws Exception {
        if (Bean.class.isAssignableFrom(declaredType)) {
            if (input instanceof Map) {
                return this.parseBean((Map)input, declaredType);
            }
            return this.parseSimple(input, declaredType);
        }
        if (input instanceof List || input instanceof Map) {
            SerIterable childIterable = null;
            if (metaProp != null) {
                childIterable = this.settings.getIteratorFactory().createIterable(metaProp, beanType, true);
            } else if (parentIterable != null) {
                childIterable = this.settings.getIteratorFactory().createIterable(parentIterable);
            }
            if (childIterable == null) {
                childIterable = input instanceof List ? (declaredType.isArray() ? SerIteratorFactory.array(declaredType.getComponentType()) : SerIteratorFactory.list(Object.class, Collections.emptyList())) : SerIteratorFactory.map(String.class, Object.class, Collections.emptyList());
            }
            return this.parseIterable(input, childIterable);
        }
        return this.parseSimple(input, declaredType);
    }

    private Object parseIterable(Object input, SerIterable iterable) throws Exception {
        if (iterable.category() == SerCategory.MAP) {
            return this.parseIterableMap(input, iterable);
        }
        if (iterable.category() == SerCategory.COUNTED) {
            return this.parseIterableCounted(input, iterable);
        }
        if (iterable.category() == SerCategory.TABLE) {
            return this.parseIterableTable(input, iterable);
        }
        if (iterable.category() == SerCategory.GRID) {
            return this.parseIterableGrid(input, iterable);
        }
        return this.parseIterableArray(input, iterable);
    }

    private Object parseIterableMap(Object input, SerIterable iterable) throws Exception {
        if (input instanceof Map) {
            for (Map.Entry entry : ((Map)input).entrySet()) {
                String keyStr = (String)entry.getKey();
                Object key = this.convertText(keyStr, iterable.keyType());
                Object value = this.parseObject(entry.getValue(), iterable.valueType(), null, null, iterable);
                iterable.add(key, null, value, 1);
            }
            return iterable.build();
        }
        if (input instanceof List) {
            List inputList = (List)input;
            for (Object inputVal : inputList) {
                List inputData = (List)inputVal;
                if (inputData.size() != 3) {
                    throw new IllegalArgumentException("Expected table iterable to have entries of size 3");
                }
                Object key = this.parseObject(inputData.get(0), iterable.keyType(), null, null, null);
                Object value = this.parseObject(inputData.get(2), iterable.valueType(), null, null, iterable);
                iterable.add(key, null, value, 1);
            }
            return iterable.build();
        }
        throw new IllegalArgumentException("Invalid data: Expected List or Map but found " + input);
    }

    private Object parseIterableTable(Object input, SerIterable iterable) throws Exception {
        List inputList = (List)input;
        for (Object inputVal : inputList) {
            List inputData = (List)inputVal;
            if (inputData.size() != 3) {
                throw new IllegalArgumentException("Expected table iterable to have entries of size 3");
            }
            Object key = this.parseObject(inputData.get(0), iterable.keyType(), null, null, null);
            Object col = this.parseObject(inputData.get(1), iterable.columnType(), null, null, null);
            Object value = this.parseObject(inputData.get(2), iterable.valueType(), null, null, iterable);
            iterable.add(key, col, value, 1);
        }
        return iterable.build();
    }

    private Object parseIterableGrid(Object input, SerIterable iterable) throws Exception {
        List inputList = (List)input;
        if (inputList.size() < 2) {
            throw new IllegalArgumentException("Expected counted iterable to be size 3");
        }
        Integer rows = (Integer)inputList.get(0);
        Integer columns = (Integer)inputList.get(1);
        iterable.dimensions(new int[]{rows, columns});
        for (Object inputVal : inputList.subList(2, inputList.size())) {
            List inputData = (List)inputVal;
            if (inputData.size() != 2) {
                throw new IllegalArgumentException("Expected grid iterable to have entries of size 3");
            }
            Integer row = (Integer)inputData.get(0);
            Integer col = (Integer)inputData.get(1);
            Object value = this.parseObject(inputData.get(2), iterable.valueType(), null, null, iterable);
            iterable.add(row, col, value, 1);
        }
        return iterable.build();
    }

    private Object parseIterableCounted(Object input, SerIterable iterable) throws Exception {
        List inputList = (List)input;
        for (Object inputVal : inputList) {
            List inputData = (List)inputVal;
            if (inputData.size() != 2) {
                throw new IllegalArgumentException("Expected counted iterable to have entries of size 2");
            }
            Object value = this.parseObject(inputData.get(0), iterable.valueType(), null, null, iterable);
            Integer count = (Integer)inputData.get(1);
            iterable.add(null, null, value, count);
        }
        return iterable.build();
    }

    private Object parseIterableArray(Object input, SerIterable iterable) throws Exception {
        List inputList = (List)input;
        for (Object inputVal : inputList) {
            Object value = this.parseObject(inputVal, iterable.valueType(), null, null, iterable);
            iterable.add(null, null, value, 1);
        }
        return iterable.build();
    }

    private Object parseSimple(Object input, Class<?> type) throws Exception {
        if (input == null) {
            if (type == Double.TYPE || type == Double.class) {
                return Double.NaN;
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(Float.NaN);
            }
            return null;
        }
        if (input instanceof String) {
            return this.convertText(input, type);
        }
        if (input instanceof Boolean) {
            return input;
        }
        if (input instanceof Long) {
            Long inputLong = (Long)input;
            if (type == Long.class || type == Long.TYPE) {
                return inputLong;
            }
            return this.convertInteger(inputLong, type);
        }
        if (input instanceof Integer) {
            Integer inputInteger = (Integer)input;
            if (type == Integer.class || type == Integer.TYPE) {
                return inputInteger;
            }
            return this.convertInteger(inputInteger.longValue(), type);
        }
        if (input instanceof Double) {
            Double inputDouble = (Double)input;
            if (type == Double.class || type == Double.TYPE) {
                return inputDouble;
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf(inputDouble.floatValue());
            }
            return this.convertInteger(inputDouble.longValue(), type);
        }
        if (input instanceof Float) {
            Float inputFloat = (Float)input;
            if (type == Float.class || type == Float.TYPE) {
                return inputFloat;
            }
            if (type == Double.class || type == Double.TYPE) {
                return inputFloat.doubleValue();
            }
            return this.convertInteger(inputFloat.longValue(), type);
        }
        if (input instanceof Short || input instanceof Byte) {
            return input;
        }
        throw new IllegalArgumentException("Invalid data: Expected simple type but found " + input);
    }

    private Object convertText(Object input, Class<?> type) {
        if (type == Object.class || type.isAssignableFrom(String.class)) {
            return input;
        }
        return this.settings.getConverter().convertFromString(type, (String)input);
    }

    private Object convertInteger(long value, Class<?> type) {
        if (type == Long.class || type == Long.TYPE) {
            return value;
        }
        if (type == Short.class || type == Short.TYPE) {
            if (value < -32768L || value > 32767L) {
                throw new IllegalArgumentException("Invalid data: Value exceeds capacity of short: " + value);
            }
            return (short)value;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            if (value < -128L || value > 127L) {
                throw new IllegalArgumentException("Invalid data: Value exceeds capacity of byte: " + value);
            }
            return (byte)value;
        }
        if (type == Double.class || type == Double.TYPE) {
            double dblVal = value;
            if (value != (long)dblVal) {
                throw new IllegalArgumentException("Invalid data: Value exceeds capacity of double: " + value);
            }
            return dblVal;
        }
        if (type == Float.class || type == Float.TYPE) {
            float fltVal = value;
            if (value != (long)fltVal) {
                throw new IllegalArgumentException("Invalid data: Value exceeds capacity of float: " + value);
            }
            return Float.valueOf(fltVal);
        }
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid data: Expected int, but was " + value);
        }
        return (int)value;
    }
}

