/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import org.joda.beans.ser.JodaBeanSer;

enum JodaBeanSerFormat {
    BIN,
    JSON,
    JSON_UTF8,
    XML,
    XML_UTF8,
    UNKNOWN;


    <T> T read(InputStream stream, Class<T> rootType, JodaBeanSer settings) {
        switch (this) {
            case BIN: {
                return settings.binReader().read(stream, rootType);
            }
            case JSON: {
                InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                return rootType.cast(settings.simpleJsonReader().read(reader, rootType));
            }
            case JSON_UTF8: {
                JodaBeanSerFormat.read(stream, 3);
                InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                return rootType.cast(settings.simpleJsonReader().read(reader, rootType));
            }
            case XML: {
                InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                return rootType.cast(settings.xmlReader().read(reader, rootType));
            }
            case XML_UTF8: {
                JodaBeanSerFormat.read(stream, 3);
                InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                return rootType.cast(settings.xmlReader().read(reader, rootType));
            }
        }
        throw new IllegalArgumentException("File is not a recognised Joda-Beans format");
    }

    private static void read(InputStream buffered, int count) {
        try {
            for (int i = 0; i < count; ++i) {
                buffered.read();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

