/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerIteratorFactory;

final class BeanIterator
implements Iterator<Bean> {
    private final List<Bean> stack = new ArrayList<Bean>(32);

    BeanIterator(Bean root) {
        this.stack.add(root);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public Bean next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements in the iterator");
        }
        Bean current = this.stack.remove(this.stack.size() - 1);
        ArrayDeque<Bean> temp = new ArrayDeque<Bean>(32);
        for (MetaProperty<?> mp : current.metaBean().metaPropertyIterable()) {
            this.findChildBeans(mp.get(current), mp, current.getClass(), temp);
        }
        this.stack.addAll(temp);
        return current;
    }

    private void findChildBeans(Object obj, MetaProperty<?> mp, Class<?> beanClass, Deque<Bean> temp) {
        if (obj != null) {
            if (obj instanceof Bean) {
                temp.addFirst((Bean)obj);
            } else {
                SerIterator it = SerIteratorFactory.INSTANCE.create(obj, mp, beanClass);
                if (it != null) {
                    while (it.hasNext()) {
                        it.next();
                        this.findChildBeans(it.key(), mp, Object.class, temp);
                        this.findChildBeans(it.value(), mp, Object.class, temp);
                        this.findChildBeans(it.column(), mp, Object.class, temp);
                    }
                }
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("BeanIterator does not support remove()");
    }
}

