/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodHandlesUtil {
    private static final int ALLOWED_MODES = 15;
    private static Constructor<MethodHandles.Lookup> java8LookupConstructor;
    private static Method privateLookupInMethod;

    public static MethodHandles.Lookup lookup(Class<?> callerClass) {
        if (privateLookupInMethod != null) {
            try {
                return (MethodHandles.Lookup)privateLookupInMethod.invoke(MethodHandles.class, callerClass, MethodHandles.lookup());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return java8LookupConstructor.newInstance(callerClass, 15);
        }
        catch (Exception e) {
            throw new IllegalStateException("no 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
        }
    }

    public static MethodHandle getSpecialMethodHandle(Method parentMethod) {
        Class<?> declaringClass = parentMethod.getDeclaringClass();
        MethodHandles.Lookup lookup = MethodHandlesUtil.lookup(declaringClass);
        try {
            return lookup.unreflectSpecial(parentMethod, declaringClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            privateLookupInMethod = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException e) {
            privateLookupInMethod = null;
            System.out.println("There is no [java.lang.invoke.MethodHandles.privateLookupIn(Class, Lookup)] method in this version of JDK");
        }
        if (privateLookupInMethod == null) {
            try {
                java8LookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                java8LookupConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("There is neither 'privateLookupIn(Class, Lookup)' nor 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
            }
        }
    }
}

