/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.noear.solon.Utils;
import org.noear.solon.core.util.IoUtil;

public class DownloadedFile {
    private String contentType;
    private long contentSize;
    private InputStream content;
    private String name;
    private boolean attachment = true;

    public boolean isAttachment() {
        return this.attachment;
    }

    public DownloadedFile asAttachment(boolean attachment) {
        this.attachment = attachment;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentSize() {
        if (this.contentSize > 0L) {
            return this.contentSize;
        }
        try {
            return this.content.available();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public DownloadedFile() {
    }

    public DownloadedFile(String contentType, long contentSize, InputStream content, String name) {
        this.contentType = contentType;
        this.contentSize = contentSize;
        this.content = content;
        this.name = name;
    }

    public DownloadedFile(String contentType, InputStream content, String name) {
        this(contentType, 0L, content, name);
    }

    public DownloadedFile(String contentType, byte[] content, String name) {
        this.contentType = contentType;
        this.contentSize = content.length;
        this.content = new ByteArrayInputStream(content);
        this.name = name;
    }

    public DownloadedFile(File file) throws FileNotFoundException {
        this.contentType = Utils.mime(file.getName());
        this.contentSize = 0L;
        this.content = new FileInputStream(file);
        this.name = file.getName();
    }

    public void transferTo(File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            IoUtil.transferTo(this.content, stream);
        }
    }

    public void transferTo(OutputStream stream) throws IOException {
        IoUtil.transferTo(this.content, stream);
    }
}

