/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;

public abstract class AbstractRepoMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=false)
    protected MavenProject project;
    @Parameter(property="repo.file", required=false)
    protected File file;
    @Parameter(property="repo.url", defaultValue="http://127.0.0.1:8080/repo", required=false)
    protected String repoUrl;
    @Parameter(property="repo.user", defaultValue="demo", required=false)
    protected String repoUser;
    @Parameter(property="repo.app.name", defaultValue="${project.model.artifactId}", required=false)
    protected String repoAppName;
    @Parameter(property="repo.app.version", defaultValue="${project.model.version}", required=false)
    protected String repoAppVersion;
    @Parameter(property="repo.token", defaultValue="", required=false)
    protected String repoToken;

    public String readRepoToken() {
        if (!Strings.isBlank((CharSequence)this.repoToken)) {
            return this.repoToken.trim();
        }
        File authJson = new File(System.getProperty("user.home") + "/.nutzboot/repo/auth.json");
        if (!authJson.exists()) {
            return null;
        }
        NutMap map = (NutMap)Json.fromJsonFile(NutMap.class, (File)authJson);
        if (map.containsKey((Object)this.repoUrl)) {
            map = (NutMap)map.getAs(this.repoUrl, NutMap.class);
        }
        if (map.containsKey((Object)this.repoUser)) {
            map = (NutMap)map.getAs(this.repoUser, NutMap.class);
        }
        if (map.containsKey((Object)this.repoAppName)) {
            map = (NutMap)map.getAs(this.repoAppName, NutMap.class);
        }
        return map.getString("token");
    }
}

