/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.nutz.boot.maven.AbstractRepoMojo;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.lang.Files;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;

@Mojo(name="repo-download")
public class RepoDownloadMojo
extends AbstractRepoMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        block21: {
            if (this.file == null) {
                if (this.project == null) {
                    throw new MojoFailureException("require repo.file or pom.xml!!!");
                }
                this.file = this.project.getArtifact().getFile();
                if (this.file == null) {
                    this.file = new File("target/" + this.repoAppName + '-' + this.repoAppVersion + ".jar");
                }
            }
            if (!this.file.exists()) {
                Files.createDirIfNoExists((File)this.file.getParentFile());
            }
            Log log = this.getLog();
            try (FileOutputStream out = new FileOutputStream(this.file);){
                Response resp;
                String url = this.repoUrl + "/" + this.repoUser + "/" + this.repoAppName + "/" + this.repoAppVersion + "/" + this.file.getName() + "/";
                log.info((CharSequence)("Download URL=" + url));
                log.info((CharSequence)"Downloading... ");
                Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.GET);
                req.getHeader().set("Connection", "close");
                String token = this.readRepoToken();
                if (!Strings.isBlank((CharSequence)token)) {
                    req.getHeader().set("Repo-Token", token);
                }
                if ((resp = Sender.create((Request)req).send()).isOK()) {
                    Streams.write((OutputStream)out, (InputStream)resp.getStream());
                    break block21;
                }
                this.getLog().info((CharSequence)("Download FAIL!!! respCode=" + resp.getStatus() + "\r\n" + resp.getContent()));
                throw new MojoFailureException("respCode=" + resp.getStatus());
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)"Download FAIL!!!", (Throwable)e);
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                this.getLog().info((CharSequence)"Download FAIL!!!", e);
                throw new MojoFailureException(e.getMessage(), e);
            }
        }
    }
}

