/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.jedis;

import java.io.Closeable;
import org.nutz.aop.InterceptorChain;
import org.nutz.aop.MethodInterceptor;
import org.nutz.integration.jedis.JedisAgent;
import org.nutz.lang.Streams;
import redis.clients.jedis.Jedis;

public class RedisInterceptor
implements MethodInterceptor {
    protected JedisAgent jedisAgent;
    protected static ThreadLocal<Jedis> TL = new ThreadLocal();

    public void filter(InterceptorChain chain) throws Throwable {
        if (TL.get() != null) {
            chain.doChain();
            return;
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisAgent.jedis();
            TL.set(jedis);
            chain.doChain();
        }
        finally {
            Streams.safeClose((Closeable)jedis);
            TL.remove();
        }
    }

    public static Jedis jedis() {
        return TL.get();
    }

    public void setJedisAgent(JedisAgent jedisAgent) {
        this.jedisAgent = jedisAgent;
    }
}

