/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.jedis.pubsub;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nutz.integration.jedis.JedisAgent;
import org.nutz.integration.jedis.pubsub.PubSub;
import org.nutz.integration.jedis.pubsub.PubSubProxy;
import org.nutz.lang.Streams;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class PubSubService {
    private static final Log log = Logs.get();
    protected JedisAgent jedisAgent;
    protected List<PubSubProxy> list = new ArrayList<PubSubProxy>();
    protected Set<String> patterns = new HashSet<String>();

    public void reg(final String pattern, PubSub pb) {
        final PubSubProxy proxy = new PubSubProxy(pattern, pb);
        this.list.add(proxy);
        Thread t = new Thread("jedis.pubsub." + pattern){

            @Override
            public void run() {
                while (PubSubService.this.patterns.contains(pattern)) {
                    try {
                        PubSubService.this.jedisAgent.jedis().psubscribe((JedisPubSub)proxy, new String[]{pattern});
                    }
                    catch (Exception e) {
                        if (!PubSubService.this.patterns.contains(pattern)) break;
                        log.warn((Object)"something wrong!! sleep 3s", (Throwable)e);
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (Throwable _e) {
                            break;
                        }
                    }
                }
            }
        };
        t.start();
        this.patterns.add(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(String channel, String message) {
        log.debugf("publish channel=%s msg=%s", new Object[]{channel, message});
        Jedis jedis = null;
        try {
            jedis = this.jedisAgent.jedis();
            jedis.publish(channel, message);
        }
        finally {
            Streams.safeClose((Closeable)jedis);
        }
    }

    public void depose() {
        for (PubSubProxy proxy : this.list) {
            try {
                this.patterns.remove(proxy.pattern);
                proxy.punsubscribe(new String[]{proxy.pattern});
            }
            catch (Exception e) {
                log.debug((Object)("punsubscribe " + proxy.pattern), (Throwable)e);
            }
        }
    }

    public void setJedisAgent(JedisAgent jedisAgent) {
        this.jedisAgent = jedisAgent;
    }
}

