/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.json4excel;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.nutz.castor.Castors;
import org.nutz.integration.json4excel.J4ECellFromExcel;
import org.nutz.integration.json4excel.J4ECellSetStyle;
import org.nutz.integration.json4excel.J4ECellToExcel;
import org.nutz.integration.json4excel.J4EColumn;
import org.nutz.integration.json4excel.J4EColumnType;
import org.nutz.integration.json4excel.J4EConf;
import org.nutz.integration.json4excel.J4EEmptyRow;
import org.nutz.integration.json4excel.annotation.J4EDateFormat;
import org.nutz.integration.json4excel.annotation.J4EFormat;
import org.nutz.integration.json4excel.annotation.J4EName;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class J4E {
    private static final Log log = Logs.get();

    private J4E() {
    }

    public static <T> boolean toExcel(OutputStream out, List<T> dataList, J4EConf j4eConf) {
        HSSFWorkbook wb = j4eConf != null && j4eConf.isUse2007() ? new XSSFWorkbook() : new HSSFWorkbook();
        return J4E.toExcel((Workbook)wb, out, dataList, j4eConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean toExcel(File excel, List<T> dataList, J4EConf j4eConf) {
        HSSFWorkbook wb = j4eConf != null && j4eConf.isUse2007() ? new XSSFWorkbook() : new HSSFWorkbook();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(excel);
            boolean bl = J4E.toExcel((Workbook)wb, out, dataList, j4eConf);
            return bl;
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Streams.safeClose((Closeable)wb);
            Streams.safeClose((Closeable)out);
        }
    }

    public static <T> boolean appendExcel(File excel, List<T> dataList, J4EConf j4eConf) {
        try {
            Workbook wb = J4E.loadExcel(new FileInputStream(excel));
            if (wb == null) {
                wb = j4eConf != null && j4eConf.isUse2007() ? new XSSFWorkbook() : new HSSFWorkbook();
            }
            return J4E.toExcel(wb, new FileOutputStream(excel), dataList, j4eConf);
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    public static <T> boolean toExcel(Workbook wb, OutputStream out, List<T> dataList, J4EConf j4eConf) {
        if (dataList == null || dataList.size() == 0) {
            log.warn((Object)"datalist is empty! can't convert to excel");
            return false;
        }
        Class<?> objClz = dataList.get(0).getClass();
        Mirror mc = Mirror.me(objClz);
        Sheet sheet = wb.getSheet((j4eConf = J4E.checkJ4EConf(j4eConf, objClz)).getSheetName());
        if (sheet == null) {
            sheet = wb.createSheet(j4eConf.getSheetName());
        }
        for (J4EColumn jcol : j4eConf.getColumns()) {
            if (Strings.isBlank((CharSequence)jcol.getFieldName())) continue;
            try {
                Field cfield = mc.getField(jcol.getFieldName());
                jcol.setField(cfield);
            }
            catch (NoSuchFieldException e) {
                log.warnf("can't find Field[%s] in Class[%s]", new Object[]{jcol.getFieldName(), objClz.getName()});
            }
        }
        int passRow = j4eConf.getPassRow();
        int passColumn = j4eConf.getPassColumn();
        int cindex = 0;
        if (j4eConf.isPassHead()) {
            ++passRow;
        } else {
            Row rhead = sheet.createRow(passRow++);
            for (J4EColumn jcol : j4eConf.getColumns()) {
                Field jfield;
                if (jcol.isIgnore() || null == (jfield = jcol.getField())) continue;
                Cell c = rhead.createCell(cindex++);
                c.setCellType(CellType.STRING);
                c.setCellValue(Strings.isBlank((CharSequence)jcol.getColumnName()) ? jcol.getFieldName() : jcol.getColumnName());
            }
        }
        for (T dval : dataList) {
            int crow;
            Row row;
            if (log.isDebugEnabled()) {
                log.debugf("add Row : %s", new Object[]{Json.toJson(dval, (JsonFormat)JsonFormat.compact())});
            }
            if ((row = sheet.getRow(crow = passRow++)) == null) {
                row = sheet.createRow(crow);
            }
            cindex = passColumn;
            for (J4EColumn jcol : j4eConf.getColumns()) {
                J4ECellSetStyle cellSetStyle;
                Field jfield;
                if (jcol.isIgnore() || null == (jfield = jcol.getField())) continue;
                int ccin = cindex++;
                J4EColumnType columnType = jcol.getColumnType();
                Object dfv = mc.getValue(dval, jfield);
                Cell c = row.getCell(ccin);
                if (c == null) {
                    c = row.createCell(ccin);
                }
                if (columnType == J4EColumnType.IMAGE) {
                    try {
                        sheet.setColumnWidth(ccin, jcol.getImgWidth() * 43);
                        row.setHeight((short)(jcol.getImgHeight() * 20));
                        InputStream imgIn = (InputStream)dfv;
                        ByteArrayOutputStream outImg = new ByteArrayOutputStream();
                        Streams.writeAndClose((OutputStream)outImg, (InputStream)imgIn);
                        int pictureIdx = wb.addPicture(outImg.toByteArray(), 6);
                        CreationHelper helper = wb.getCreationHelper();
                        Drawing drawing = sheet.createDrawingPatriarch();
                        ClientAnchor anchor = helper.createClientAnchor();
                        anchor.setRow1(row.getRowNum());
                        anchor.setCol1(ccin);
                        anchor.setDx1(0);
                        anchor.setDy1(0);
                        anchor.setRow2(row.getRowNum() + 1);
                        anchor.setCol2(ccin + 1);
                        anchor.setDx1(5);
                        anchor.setDy1(5);
                        anchor.setDx2(-5);
                        anchor.setDy2(-5);
                        drawing.createPicture(anchor, pictureIdx);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (columnType == J4EColumnType.NUMERIC) {
                    c.setCellType(CellType.NUMERIC);
                    int precision = jcol.getPrecision();
                    if (precision == 0) {
                        Integer intRe = (Integer)Castors.me().castTo(dfv, Integer.class);
                        if (intRe != null) {
                            c.setCellValue((double)intRe.intValue());
                        }
                    } else {
                        Double dbRe = (Double)Castors.me().castTo(dfv, Double.class);
                        if (dbRe != null) {
                            c.setCellValue(dbRe.doubleValue());
                        }
                    }
                } else {
                    c.setCellType(CellType.STRING);
                    if (jcol.getToExcelFun() != null) {
                        J4ECellToExcel cellFun = jcol.getToExcelFun();
                        Object setVal = cellFun.toExecl(dfv);
                        c.setCellValue((String)Castors.me().castTo(setVal, String.class));
                    } else {
                        c.setCellValue(dfv != null ? (String)Castors.me().castTo(dfv, String.class) : "");
                    }
                }
                if ((cellSetStyle = jcol.getCellStyle()) == null) continue;
                cellSetStyle.setStyle(c);
            }
        }
        if (out == null) {
            return true;
        }
        return J4E.saveExcel(out, wb);
    }

    private static <T> J4EConf checkJ4EConf(J4EConf j4eConf, Class<T> objClz) {
        if (null == j4eConf) {
            j4eConf = J4EConf.from(objClz);
        }
        if (Strings.isBlank((CharSequence)j4eConf.getSheetName())) {
            String sheetName = objClz.getSimpleName();
            J4EName cName = objClz.getAnnotation(J4EName.class);
            if (cName != null && !Strings.isBlank((CharSequence)cName.value())) {
                sheetName = cName.value();
            }
            j4eConf.setSheetName(sheetName);
        }
        return j4eConf;
    }

    public static <T> List<T> fromExcel(InputStream in, Class<T> objClz, J4EConf j4eConf) {
        Workbook wb;
        Sheet sheet;
        if (null == j4eConf) {
            j4eConf = J4EConf.from(objClz);
        }
        if ((sheet = J4E.getSheet(wb = J4E.loadExcel(in), objClz, j4eConf)) == null) {
            log.error((Object)"Not Find Sheet");
            return null;
        }
        return J4E.fromSheet(sheet, objClz, j4eConf, false);
    }

    public static <T> List<T> fromSheet(Sheet sheet, Class<T> objClz, J4EConf j4eConf, boolean onlyHeader) {
        ArrayList<T> dataList;
        Mirror mc = Mirror.me(objClz);
        ArrayList<T> arrayList = dataList = j4eConf.isNoReturn() ? null : new ArrayList<T>();
        if (!Lang.equals((Object)sheet.getSheetName(), (Object)j4eConf.getSheetName())) {
            return dataList;
        }
        Iterator rlist = sheet.rowIterator();
        int passRow = j4eConf.getPassRow();
        int passContentRow = j4eConf.getPassContentRow();
        boolean passHead = j4eConf.isPassHead();
        long maxRead = j4eConf.getMaxRead();
        J4EEmptyRow<?> emptyRowChecker = j4eConf.getPassEmptyRow();
        boolean needCheckEmptyRow = emptyRowChecker != null;
        int currRow = 0;
        boolean firstRow = true;
        long readNum = 0L;
        while (rlist.hasNext() && (maxRead <= 0L || readNum < maxRead)) {
            Row row = (Row)rlist.next();
            if (currRow >= passRow) {
                if (firstRow) {
                    if (!passHead) {
                        Iterator<J4EColumn> clist = row.cellIterator();
                        int cindex = 0;
                        HashMap<String, Integer> headIndexMap = new HashMap<String, Integer>();
                        while (clist.hasNext()) {
                            Cell chead = (Cell)clist.next();
                            headIndexMap.put(J4E.cellValue(chead, null), cindex++);
                        }
                        for (J4EColumn jcol : j4eConf.getColumns()) {
                            if (null != headIndexMap.get(jcol.getColumnName())) {
                                jcol.setColumnIndex((Integer)headIndexMap.get(jcol.getColumnName()));
                                continue;
                            }
                            if (null != headIndexMap.get(jcol.getFieldName())) {
                                jcol.setColumnIndex((Integer)headIndexMap.get(jcol.getFieldName()));
                                continue;
                            }
                            if (null != jcol.getColumnIndex() && jcol.getColumnIndex() >= 0) {
                                log.warnf("J4EColumn has already set index[%d], but not sure It is right", new Object[]{jcol.getColumnIndex()});
                                continue;
                            }
                            jcol.setColumnIndex(null);
                        }
                    }
                    for (J4EColumn jcol : j4eConf.getColumns()) {
                        if (jcol.getColumnIndex() == null || jcol.getColumnIndex() < 0) continue;
                        try {
                            Field cfield = mc.getField(jcol.getFieldName());
                            jcol.setField(cfield);
                            J4EDateFormat dFormat = cfield.getAnnotation(J4EDateFormat.class);
                            if (dFormat == null) continue;
                            String f = dFormat.from();
                            String t = dFormat.to();
                            if (Strings.isBlank((CharSequence)f) && Strings.isBlank((CharSequence)t)) continue;
                            jcol.setDtFormat(new String[]{f, t});
                        }
                        catch (NoSuchFieldException e) {
                            log.warnf("can't find Field[%s] in Class[%s]", new Object[]{jcol.getFieldName(), objClz.getName()});
                        }
                    }
                    log.debugf("J4EConf-Columns : \n%s", new Object[]{Json.toJson(j4eConf.getColumns())});
                    firstRow = false;
                    if (!onlyHeader) continue;
                    break;
                }
                if (passContentRow > 0) {
                    --passContentRow;
                    continue;
                }
                ++readNum;
                T rVal = J4E.rowValue(row, j4eConf, mc);
                if (null != j4eConf.getEachPrepare()) {
                    j4eConf.getEachPrepare().doEach(rVal);
                } else if (null != j4eConf.getEachModify()) {
                    j4eConf.getEachModify().doEach(rVal, row, j4eConf.getColumns());
                }
                if (!j4eConf.isNoReturn()) {
                    if (needCheckEmptyRow) {
                        if (!emptyRowChecker.isEmpty(rVal)) {
                            dataList.add(rVal);
                        }
                    } else {
                        dataList.add(rVal);
                    }
                }
            }
            ++currRow;
        }
        if (null != j4eConf.getModifyOutput()) {
            J4E.saveExcel(j4eConf.getModifyOutput(), sheet.getWorkbook());
        }
        return dataList;
    }

    public static <T> boolean matchExcel(InputStream in, Class<T> objClz) {
        J4EConf j4eConf = J4EConf.from(objClz);
        Workbook wb = J4E.loadExcel(in);
        Sheet sheet = J4E.getSheet(wb, objClz, j4eConf);
        J4E.fromSheet(sheet, objClz, j4eConf, true);
        int jcnum = 0;
        int jcfind = 0;
        for (J4EColumn jcol : j4eConf.getColumns()) {
            if (jcol.getColumnIndex() != null) {
                ++jcfind;
            }
            ++jcnum;
        }
        return jcfind == jcnum;
    }

    public static <T> T rowValue(Row row, J4EConf j4eConf, Mirror<T> mc) {
        Object rVal = mc.born(new Object[0]);
        for (J4EColumn jcol : j4eConf.getColumns()) {
            String cVal;
            Field jfield = jcol.getField();
            if (null == jfield) continue;
            Cell cell = row.getCell(jcol.getColumnIndex() + j4eConf.getPassColumn());
            if (null == cell) {
                log.warn((Object)String.format("cell [%d, %d] has null, so value is ''", row.getRowNum(), jcol.getColumnIndex()));
            }
            String string = cVal = null == cell ? "" : J4E.cellValue(cell, jcol);
            if (jcol.getFromExcelFun() != null) {
                J4ECellFromExcel cellFun = jcol.getFromExcelFun();
                Object setVal = cellFun.fromExcel(cVal);
                mc.setValue(rVal, jfield, setVal);
                continue;
            }
            mc.setValue(rVal, jfield, (Object)cVal);
        }
        return (T)rVal;
    }

    public static String cellValue(Cell c, J4EColumn jcol) {
        J4EColumnType colType = null;
        if (jcol != null) {
            colType = jcol.getColumnType();
        }
        if (null == colType) {
            colType = J4EColumnType.STRING;
        }
        try {
            CellType cType = c.getCellTypeEnum();
            switch (cType) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)c)) {
                        Date dval = c.getDateCellValue();
                        if (jcol.getDtFormat() != null) {
                            try {
                                return Times.format((String)jcol.getDtFormat()[1], (Date)dval);
                            }
                            catch (Exception e) {
                                log.error((Object)String.format("cell [%d, %d] datetime formate err, value %s [%s-%s]", c.getRowIndex(), c.getColumnIndex(), dval.toString(), jcol.getDtFormat()[0], jcol.getDtFormat()[1], e));
                            }
                        }
                        return Times.sDT((Date)dval);
                    }
                    if (J4EColumnType.STRING == colType) {
                        DecimalFormat df = new DecimalFormat("0");
                        return df.format(c.getNumericCellValue());
                    }
                    if (J4EColumnType.NUMERIC == colType) {
                        if (jcol.getPrecision() == 0) {
                            return "" + (int)c.getNumericCellValue();
                        }
                        String fString = "0." + Strings.alignLeft((Object)"", (int)jcol.getPrecision(), (char)'0');
                        DecimalFormat df = new DecimalFormat(fString);
                        return df.format(c.getNumericCellValue());
                    }
                    throw new RuntimeException("WTF, CELL_TYPE_NUMERIC is what!");
                }
                case STRING: {
                    String strResult = Strings.trim((CharSequence)c.getStringCellValue());
                    if (!Strings.isBlank((CharSequence)strResult) && jcol != null) {
                        J4EFormat strFormat;
                        if (jcol.getDtFormat() != null) {
                            try {
                                strResult = Times.format((String)jcol.getDtFormat()[1], (Date)Times.parse((String)jcol.getDtFormat()[0], (String)strResult));
                            }
                            catch (Exception e) {
                                log.error((Object)String.format("cell [%d, %d] datetime formate err, value %s [%s-%s]", c.getRowIndex(), c.getColumnIndex(), strResult, jcol.getDtFormat()[0], jcol.getDtFormat()[1], e));
                            }
                        }
                        if ((strFormat = jcol.getField().getAnnotation(J4EFormat.class)) != null) {
                            if (strFormat.LowerCase()) {
                                strResult = strResult.toLowerCase();
                            }
                            if (strFormat.UpperCase()) {
                                strResult = strResult.toUpperCase();
                            }
                        }
                    }
                    return strResult;
                }
                case BOOLEAN: {
                    return String.valueOf(c.getBooleanCellValue());
                }
                case FORMULA: {
                    return Strings.trim((CharSequence)String.valueOf(c.getStringCellValue()));
                }
            }
            return Strings.trim((CharSequence)c.getStringCellValue());
        }
        catch (Exception e) {
            log.error((Object)String.format("cell [%d, %d] has error, value can't convert to string", c.getRowIndex(), c.getColumnIndex()), (Throwable)e);
            return "";
        }
    }

    public static Sheet getSheet(Workbook wb, Class<?> objClz, J4EConf j4eConf) {
        Sheet sheet = null;
        if (!Strings.isBlank((CharSequence)j4eConf.getSheetName())) {
            String[] snArray;
            for (String sn : snArray = j4eConf.getSheetName().split("\\|")) {
                sheet = wb.getSheet(sn);
                if (sheet == null) continue;
                log.infof("find sheet by name [%s]", new Object[]{sn});
                break;
            }
        }
        if (null == sheet) {
            sheet = wb.getSheetAt(j4eConf.getSheetIndex());
        }
        if (null == sheet) {
            log.errorf("excel not has sheet at [%d] or sheetName is [%s]", new Object[]{j4eConf.getSheetIndex(), j4eConf.getSheetName()});
        }
        return sheet;
    }

    public static Workbook loadExcel(InputStream in) {
        Workbook wb = null;
        try {
            try {
                wb = WorkbookFactory.create((InputStream)in);
            }
            catch (Exception e1) {
                try {
                    wb = new HSSFWorkbook(in);
                }
                catch (Exception e2) {
                    wb = new XSSFWorkbook(in);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"can't load inputstream for a workbook", (Throwable)e);
        }
        return wb;
    }

    public static boolean saveExcel(OutputStream out, Workbook wb) {
        try {
            wb.write(out);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"can't write wookbook to outputstream", (Throwable)e);
            return false;
        }
    }
}

