/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.json4excel;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.nutz.integration.json4excel.J4ECellFromExcel;
import org.nutz.integration.json4excel.J4ECellFromExcelImpl;
import org.nutz.integration.json4excel.J4ECellSetStyle;
import org.nutz.integration.json4excel.J4ECellSetStyleImpl;
import org.nutz.integration.json4excel.J4ECellToExcel;
import org.nutz.integration.json4excel.J4ECellToExcelImpl;
import org.nutz.integration.json4excel.J4EColumn;
import org.nutz.integration.json4excel.J4EEachRow;
import org.nutz.integration.json4excel.J4EEachRowModify;
import org.nutz.integration.json4excel.J4EEmptyRow;
import org.nutz.integration.json4excel.J4EEmptyRowImpl;
import org.nutz.integration.json4excel.annotation.J4ECell;
import org.nutz.integration.json4excel.annotation.J4ECellStyle;
import org.nutz.integration.json4excel.annotation.J4EDefine;
import org.nutz.integration.json4excel.annotation.J4EExt;
import org.nutz.integration.json4excel.annotation.J4EIgnore;
import org.nutz.integration.json4excel.annotation.J4EName;
import org.nutz.json.Json;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Disks;

public class J4EConf {
    private int sheetIndex;
    private String sheetName;
    private int passColumn;
    private int passRow;
    private int passContentRow;
    private boolean passHead;
    private long maxWrite;
    private long maxRead;
    private J4EEmptyRow passEmptyRow;
    private List<J4EColumn> columns;
    private J4EEachRow eachPrepare;
    private J4EEachRowModify eachModify;
    private OutputStream modifyOut;
    private boolean noReturn;
    private boolean use2007;

    public boolean isUse2007() {
        return this.use2007;
    }

    public J4EConf setUse2007(boolean use2007) {
        this.use2007 = use2007;
        return this;
    }

    public boolean isNoReturn() {
        return this.noReturn;
    }

    public J4EConf setNoReturn(boolean noReturn) {
        this.noReturn = noReturn;
        return this;
    }

    public J4EEachRow getEachPrepare() {
        return this.eachPrepare;
    }

    public J4EConf setEachPrepare(J4EEachRow eachPrepare) {
        this.eachPrepare = eachPrepare;
        this.noReturn = true;
        return this;
    }

    public J4EEachRowModify getEachModify() {
        return this.eachModify;
    }

    public OutputStream getModifyOutput() {
        return this.modifyOut;
    }

    public J4EConf setEachModify(J4EEachRowModify eachModify, OutputStream out) {
        this.eachModify = eachModify;
        this.modifyOut = out;
        this.noReturn = true;
        return this;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public J4EConf setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
        return this;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public J4EConf setSheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public List<J4EColumn> getColumns() {
        return this.columns;
    }

    public J4EConf setColumns(List<J4EColumn> columns) {
        this.columns = columns;
        return this;
    }

    public int getPassColumn() {
        return this.passColumn;
    }

    public J4EConf setPassColumn(int passColumn) {
        this.passColumn = passColumn;
        return this;
    }

    public int getPassRow() {
        return this.passRow;
    }

    public J4EConf setPassRow(int passRow) {
        this.passRow = passRow;
        return this;
    }

    public boolean isPassHead() {
        return this.passHead;
    }

    public void setPassHead(boolean passHead) {
        this.passHead = passHead;
    }

    public int getPassContentRow() {
        return this.passContentRow;
    }

    public void setPassContentRow(int passContentRow) {
        this.passContentRow = passContentRow;
    }

    public OutputStream getModifyOut() {
        return this.modifyOut;
    }

    public void setModifyOut(OutputStream modifyOut) {
        this.modifyOut = modifyOut;
    }

    public void setEachModify(J4EEachRowModify eachModify) {
        this.eachModify = eachModify;
    }

    public J4EEmptyRow<?> getPassEmptyRow() {
        return this.passEmptyRow;
    }

    public void setPassEmptyRow(Class<? extends J4EEmptyRow> cellFun) {
        Mirror mc = Mirror.me(cellFun);
        this.passEmptyRow = (J4EEmptyRow)mc.born(new Object[0]);
    }

    public long getMaxWrite() {
        return this.maxWrite;
    }

    public void setMaxWrite(long maxWrite) {
        this.maxWrite = maxWrite;
    }

    public long getMaxRead() {
        return this.maxRead;
    }

    public void setMaxRead(long maxRead) {
        this.maxRead = maxRead;
    }

    public static J4EConf from(Class<?> clz) {
        J4EConf jc = new J4EConf();
        J4EExt ecnf = clz.getAnnotation(J4EExt.class);
        if (ecnf != null) {
            jc.passRow = ecnf.passRow();
            jc.passColumn = ecnf.passColumn();
            jc.passHead = ecnf.passHead();
            jc.passContentRow = ecnf.passContentRow();
            jc.maxRead = ecnf.maxRead();
            jc.maxWrite = ecnf.maxWrite();
            Class<J4EEmptyRow<J4EEmptyRowImpl>> perow = ecnf.passEmptyRow();
            if (!perow.isAssignableFrom(J4EEmptyRowImpl.class)) {
                jc.setPassEmptyRow(perow);
            }
        }
        String sheetName = null;
        J4EName cName = clz.getAnnotation(J4EName.class);
        if (cName != null && !Strings.isBlank((CharSequence)cName.value())) {
            sheetName = cName.value();
        }
        jc.setSheetName(sheetName);
        ArrayList<J4EColumn> jclist = new ArrayList<J4EColumn>();
        Mirror mc = Mirror.me(clz);
        for (Field cf : mc.getFields()) {
            Class<? extends J4ECellSetStyle> toExcelFun;
            J4ECellStyle cellStyle;
            J4ECell cellset;
            J4EIgnore ignore;
            J4EDefine define;
            J4EColumn jcol = new J4EColumn();
            jcol.setFieldName(cf.getName());
            jcol.setColumnName(cf.getName());
            J4EName fName = cf.getAnnotation(J4EName.class);
            if (fName != null && !Strings.isBlank((CharSequence)fName.value())) {
                jcol.setColumnName(fName.value());
            }
            if ((define = cf.getAnnotation(J4EDefine.class)) != null) {
                jcol.setColumnType(define.type());
                jcol.setPrecision(define.precision());
                jcol.setImgHeight(define.imgHeight());
                jcol.setImgWidth(define.imgWidth());
                if (define.columnIndex() > -1) {
                    jcol.setColumnIndex(define.columnIndex());
                }
            }
            if ((ignore = cf.getAnnotation(J4EIgnore.class)) != null) {
                jcol.setIgnore(true);
            }
            if ((cellset = cf.getAnnotation(J4ECell.class)) != null) {
                Class<? extends J4ECellFromExcel> fromExcelFun;
                Class<? extends J4ECellToExcel> toExcelFun2 = cellset.toExcel();
                if (!toExcelFun2.isAssignableFrom(J4ECellToExcelImpl.class)) {
                    jcol.setToExcelFun(toExcelFun2);
                }
                if (!(fromExcelFun = cellset.fromExcel()).isAssignableFrom(J4ECellFromExcelImpl.class)) {
                    jcol.setFromExcelFun(fromExcelFun);
                }
            }
            if ((cellStyle = cf.getAnnotation(J4ECellStyle.class)) != null && !(toExcelFun = cellStyle.setStyle()).isAssignableFrom(J4ECellSetStyleImpl.class)) {
                jcol.setCellStyle(toExcelFun);
            }
            jclist.add(jcol);
        }
        jc.setColumns(jclist);
        return jc;
    }

    public static J4EConf from(File confFile) {
        return (J4EConf)Json.fromJsonFile(J4EConf.class, (File)confFile);
    }

    public static J4EConf from(String confPath) {
        return (J4EConf)Json.fromJsonFile(J4EConf.class, (File)new File(Disks.absolute((String)confPath)));
    }

    public static J4EConf from(Reader confReader) {
        return (J4EConf)Json.fromJson(J4EConf.class, (Reader)confReader);
    }

    public static J4EConf from(InputStream confInputStream) {
        return (J4EConf)Json.fromJson(J4EConf.class, (Reader)new InputStreamReader(confInputStream));
    }

    public static J4EConf fromConf(CharSequence confStr) {
        return (J4EConf)Json.fromJson(J4EConf.class, (CharSequence)confStr);
    }
}

