/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean(create="init", depose="depose")
public class RabbitMqBeans {
    @Inject
    public PropertiesProxy conf;
    protected ExecutorService es;

    public void init() {
        this.es = Executors.newFixedThreadPool(this.conf.getInt("rabbitmq.concurrency", 10));
    }

    public void depose() {
        if (this.es != null) {
            this.es.shutdown();
        }
    }

    @IocBean(name="rabbitmq_cf")
    public ConnectionFactory createConnectionFactory() {
        ConnectionFactory connectionFactory = (ConnectionFactory)this.conf.make(ConnectionFactory.class, "rabbitmq.");
        connectionFactory.setSharedExecutor(this.es);
        return connectionFactory;
    }
}

