/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.wkcache;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.nutz.aop.InterceptorChain;
import org.nutz.el.El;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.CharSegment;
import org.nutz.lang.util.Context;
import org.nutz.lang.util.MethodParamNamesScaner;
import org.nutz.plugins.wkcache.AbstractWkcacheInterceptor;
import org.nutz.plugins.wkcache.annotation.CacheDefaults;
import org.nutz.plugins.wkcache.annotation.CacheRemove;

@IocBean(singleton=false)
public class WkcacheRemoveEntryInterceptor
extends AbstractWkcacheInterceptor {
    public void filter(InterceptorChain chain) throws Throwable {
        Method method = chain.getCallingMethod();
        CacheRemove cacheRemove = method.getAnnotation(CacheRemove.class);
        String cacheKey = Strings.sNull((Object)cacheRemove.cacheKey());
        String cacheName = Strings.sNull((Object)cacheRemove.cacheName());
        if (Strings.isBlank((CharSequence)cacheKey)) {
            cacheKey = method.getDeclaringClass().getName() + "." + method.getName() + "#" + Arrays.toString(chain.getArgs());
        } else {
            this.key = new CharSegment(cacheKey);
            if (this.key.hasKey()) {
                Context ctx = Lang.context();
                Object[] args = chain.getArgs();
                List names = MethodParamNamesScaner.getParamNames((Method)method);
                if (names != null) {
                    for (int i = 0; i < names.size() && i < args.length; ++i) {
                        ctx.set((String)names.get(i), args[i]);
                    }
                }
                ctx.set("args", (Object)args);
                Context _ctx = Lang.context();
                for (String key : this.key.keys()) {
                    _ctx.set(key, new El((CharSequence)key).eval(ctx));
                }
                cacheKey = this.key.render(_ctx).toString();
            } else {
                cacheKey = this.key.getOrginalString();
            }
        }
        if (Strings.isBlank((CharSequence)cacheName)) {
            CacheDefaults cacheDefaults = method.getDeclaringClass().getAnnotation(CacheDefaults.class);
            String string = cacheName = cacheDefaults != null ? cacheDefaults.cacheName() : "wk";
        }
        if (cacheKey.endsWith("*")) {
            Set set = this.redisService().keys((cacheName + ":" + cacheKey).getBytes());
            for (byte[] it : set) {
                this.redisService().del(it);
            }
        } else {
            this.redisService().del((cacheName + ":" + cacheKey).getBytes());
        }
        chain.doChain();
    }
}

