/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.beetl;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.beetl.ext.nutz.LogErrorHandler;
import org.nutz.boot.AppContext;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class BeetlGroupTemplateStarter {
    protected static final String PRE = "beetl.";
    @PropDoc(value="\u5360\u4f4d\u7b26\u7684\u5b9a\u754c\u7b26\u7684\u8d77\u59cb\u7b26\u53f7", defaultValue="${")
    public static final String PROP_DELIMITER_PLACEHOLDER_START = "beetl." + Configuration.DELIMITER_PLACEHOLDER_START;
    @PropDoc(value="\u5360\u4f4d\u7b26\u7684\u5b9a\u754c\u7b26\u7684\u7ed3\u675f\u7b26\u53f7", defaultValue="}")
    public static final String PROP_DELIMITER_PLACEHOLDER_END = "beetl." + Configuration.DELIMITER_PLACEHOLDER_END;
    @PropDoc(value="\u8bed\u53e5\u7684\u5b9a\u754c\u7b26\u7684\u8d77\u59cb\u7b26\u53f7", defaultValue="<%")
    public static final String PROP_DELIMITER_STATEMENT_START = "beetl." + Configuration.DELIMITER_STATEMENT_START;
    @PropDoc(value="\u8bed\u53e5\u7684\u5b9a\u754c\u7b26\u7684\u7ed3\u675f\u7b26\u53f7", defaultValue="%>")
    public static final String PROP_DELIMITER_STATEMENT_END = "beetl." + Configuration.DELIMITER_STATEMENT_END;
    @PropDoc(value="\u662f\u5426\u5141\u8bb8\u539f\u751f\u8c03\u7528", defaultValue="false")
    public static final String PROP_NATIVE_CALL = "beetl." + Configuration.NATIVE_CALL;
    @PropDoc(value="\u662f\u5426\u5ffd\u7565\u5ba2\u6237\u7aefIO\u9519\u8bef", defaultValue="false")
    public static final String PROP_IGNORE_CLIENT_IO_ERROR = "beetl." + Configuration.IGNORE_CLIENT_IO_ERROR;
    @PropDoc(value="\u76f4\u63a5\u8f93\u51fa\u5b57\u8282\u6d41", defaultValue="true")
    public static final String PROP_DIRECT_BYTE_OUTPUT = "beetl." + Configuration.DIRECT_BYTE_OUTPUT;
    @PropDoc(value="\u6a21\u677f\u76ee\u5f55\u7684\u8def\u5f84", defaultValue="template/")
    public static final String PROP_TEMPLATE_ROOT = "beetl.RESOURCE.root";
    @PropDoc(value="\u6a21\u677f\u76ee\u5f55\u7684\u7edd\u5bf9\u8def\u5f84,\u82e5\u4e0d\u5b58\u5728,\u56de\u843d\u5230'\u6a21\u677f\u76ee\u5f55\u7684\u8def\u5f84'")
    public static final String PROP_TEMPLATE_ROOT_LOCAL = "beetl.RESOURCE.rootLocal";
    @PropDoc(value="\u81ea\u52a8\u68c0\u6d4b\u6a21\u677f\u66f4\u65b0", defaultValue="true")
    public static final String PROP_TEMPLATE_AUTO_CHECK = "beetl.RESOURCE.autoCheck";
    @PropDoc(value="\u6a21\u677f\u5b57\u7b26\u96c6", defaultValue="UTF-8")
    public static final String PROP_TEMPLATE_CHARSET = "beetl." + Configuration.TEMPLATE_CHARSET;
    @PropDoc(value="\u9519\u8bef\u5904\u7406\u5668", defaultValue="org.beetl.ext.nutz.LogErrorHandler")
    public static final String PROP_ERROR_HANDLER = "beetl." + Configuration.ERROR_HANDLER;
    @PropDoc(value="MVC\u4e25\u683c\u6a21\u5f0f", defaultValue="false")
    public static final String PROP_MVC_STRICT = "beetl." + Configuration.MVC_STRICT;
    @PropDoc(value="\u6269\u5c55\u5168\u5c40\u53d8\u91cf\u7684\u5b9e\u73b0\u7c7b")
    public static final String PROP_WEBAPP_EXT = "beetl." + Configuration.WEBAPP_EXT;
    @PropDoc(value="\u662f\u5426\u652f\u6301Html\u6807\u7b7e", defaultValue="false")
    public static final String PROP_HTML_TAG_SUPPORT = "beetl." + Configuration.HTML_TAG_SUPPORT;
    @PropDoc(value="html\u6807\u7b7e\u524d\u7f00")
    public static final String PROP_HTML_TAG_FLAG = "beetl." + Configuration.HTML_TAG_FLAG;
    @PropDoc(value="\u9700\u8981\u5bfc\u5165\u54ea\u4e9bpackage")
    public static final String PROP_IMPORT_PACKAGE = "beetl." + Configuration.IMPORT_PACKAGE;
    @PropDoc(value="\u6e32\u67d3\u5f15\u64ce", defaultValue="org.beetl.core.engine.FastRuntimeEngine")
    public static final String PROP_ENGINE = "beetl." + Configuration.ENGINE;
    @PropDoc(value="\u672c\u5730\u652f\u6301\u7684\u5b89\u5168\u7ba1\u7406\u5668", defaultValue="org.beetl.core.DefaultNativeSecurityManager")
    public static final String PROP_NATIVE_SECUARTY_MANAGER = "beetl." + Configuration.NATIVE_SECUARTY_MANAGER;
    @PropDoc(value="\u6a21\u677f\u52a0\u8f7d\u5668", defaultValue="org.beetl.core.resource.ClasspathResourceLoader")
    public static final String PROP_RESOURCE_LOADER = "beetl." + Configuration.RESOURCE_LOADER;
    @PropDoc(value="html\u6807\u7b7e\u7ed1\u5b9a\u5c5e\u6027")
    public static final String PROP_HTML_TAG_BINDING_ATTRIBUTE = "beetl." + Configuration.HTML_TAG_BINDING_ATTRIBUTE;
    @PropDoc(value="\u6a21\u677f\u51fd\u6570\u7684\u8bed\u53e5\u5b9a\u754c\u7b26")
    public static final String PROP_FUNCTION_TAG_LIMITER = "beetl." + Configuration.FUNCTION_TAG_LIMITER;
    private static final Log log = Logs.get();
    @Inject
    protected PropertiesProxy conf;
    @Inject
    protected AppContext appContext;

    @IocBean(depose="close")
    public GroupTemplate getGroupTemplate() throws IOException {
        Properties prop = new Properties();
        for (String key : this.conf.keySet()) {
            if (!key.startsWith(PRE)) continue;
            prop.put(key.substring(PRE.length()), this.conf.get(key));
        }
        if (!prop.containsKey(Configuration.RESOURCE_LOADER)) {
            prop.put(Configuration.RESOURCE_LOADER, ClasspathResourceLoader.class.getName());
        }
        if (!prop.containsKey("RESOURCE.autoCheck")) {
            prop.put("RESOURCE.autoCheck", "true");
        }
        if (!prop.containsKey("RESOURCE.root")) {
            prop.put("RESOURCE.root", prop.getProperty("root", "template/"));
        }
        if (!prop.containsKey(Configuration.DIRECT_BYTE_OUTPUT)) {
            log.debug((Object)"no custom DIRECT_BYTE_OUTPUT found , set to true");
            prop.put(Configuration.DIRECT_BYTE_OUTPUT, "true");
        }
        if (!prop.containsKey(Configuration.ERROR_HANDLER)) {
            prop.put(Configuration.ERROR_HANDLER, LogErrorHandler.class.getName());
        }
        Configuration cfg = new Configuration(prop);
        String local = this.conf.get(PROP_TEMPLATE_ROOT_LOCAL);
        GroupTemplate gt = new GroupTemplate(cfg);
        if (!Strings.isBlank((CharSequence)local)) {
            try {
                if (new File(local).exists()) {
                    local = new File(local).getAbsolutePath();
                    FileResourceLoader resourceLoader = new FileResourceLoader(local);
                    resourceLoader.setAutoCheck(true);
                    gt.setResourceLoader((ResourceLoader)resourceLoader);
                    log.debugf("Template Local path=%s is ok, use it", new Object[]{local});
                }
            }
            catch (Throwable e) {
                log.infof("Template Local path=%s is not vaild, fallback to beetl.RESOURCE.root", new Object[]{local, e});
            }
        }
        return gt;
    }
}

