/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.fastdfs;

import java.net.Socket;
import java.net.SocketAddress;
import java.util.Properties;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class FastDfsClientFactory
implements PooledObjectFactory<TrackerServer> {
    private Log log = Logs.get();

    public FastDfsClientFactory(Properties props) {
        try {
            ClientGlobal.initByProperties((Properties)props);
        }
        catch (Exception e) {
            this.log.error((Object)"init pool factory error", (Throwable)e);
        }
    }

    public PooledObject<TrackerServer> makeObject() throws Exception {
        TrackerClient trackerClient = new TrackerClient();
        TrackerServer trackerServer = trackerClient.getConnection();
        return new DefaultPooledObject((Object)trackerServer);
    }

    public void destroyObject(PooledObject<TrackerServer> pooledObject) throws Exception {
        TrackerServer trackerServer = (TrackerServer)pooledObject.getObject();
        if (trackerServer != null && trackerServer.getSocket().isConnected()) {
            ProtoCommon.closeSocket((Socket)trackerServer.getSocket());
        }
    }

    public boolean validateObject(PooledObject<TrackerServer> pooledObject) {
        try {
            TrackerServer trackerServer = (TrackerServer)pooledObject.getObject();
            return ProtoCommon.activeTest((Socket)trackerServer.getSocket());
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return false;
        }
    }

    public void activateObject(PooledObject<TrackerServer> pooledObject) throws Exception {
        TrackerServer trackerServer = (TrackerServer)pooledObject.getObject();
        if (trackerServer != null) {
            SocketAddress socketAddress;
            if (trackerServer.getSocket() != null && !trackerServer.getSocket().isConnected() && (socketAddress = trackerServer.getSocket().getRemoteSocketAddress()) != null) {
                trackerServer.getSocket().connect(socketAddress);
            }
        } else {
            this.makeObject();
        }
    }

    public void passivateObject(PooledObject<TrackerServer> pooledObject) throws Exception {
    }
}

