/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.fastdfs;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.TrackerServer;
import org.nutz.boot.starter.fastdfs.FastDfsClientFactory;
import org.nutz.boot.starter.fastdfs.FastDfsClientPool;
import org.nutz.filepool.FilePool;
import org.nutz.filepool.NutFilePool;
import org.nutz.img.Images;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.Disks;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean(create="init", depose="close")
public class FastdfsService {
    private static final Log log = Logs.get();
    private static final String PRE = "fastdfs.";
    private static String IMAGE_WATERMARK_SUFFIX = "-wmark";
    private static String IMAGE_THUMB_SUFFIX = "-thumb";
    private static int IMAGE_THUMB_WIDTH = 150;
    private static int IMAGE_THUMB_HEIGHT = 150;
    private static final int DEFAULT_LOCATION = 5;
    private static final float DEFAULT_OPACITY = 0.5f;
    private static final int DEFAULT_MARGIN = 0;
    private static final String FILENAME_SEPERATOR = "/";
    private static final String EXT_SEPERATOR = ".";
    private static FilePool filePool;
    @Inject
    private PropertiesProxy conf;
    private FastDfsClientFactory fastDfsClientFactory;
    private FastDfsClientPool fastDfsClientPool;

    public void init() {
        Properties prop = new Properties();
        for (String key : this.conf.keySet()) {
            if (!key.startsWith(PRE)) continue;
            prop.put(key, this.conf.get(key));
        }
        IMAGE_WATERMARK_SUFFIX = this.conf.get("fastdfs.image.waterMarkSuffix", "-wmark");
        IMAGE_THUMB_SUFFIX = this.conf.get("fastdfs.image.thumbSuffix", "-thumb");
        IMAGE_THUMB_WIDTH = this.conf.getInt("fastdfs.image.thumbWidth", 150);
        IMAGE_THUMB_HEIGHT = this.conf.getInt("fastdfs.image.thumbHeight", 150);
        GenericObjectPoolConfig cfg = new GenericObjectPoolConfig();
        cfg.setMaxIdle(this.conf.getInt("fastdfs.pool.maxIdle", 10));
        cfg.setMinIdle(this.conf.getInt("fastdfs.pool.minIdle", 1));
        cfg.setMaxTotal(this.conf.getInt("fastdfs.pool.maxTotal", 20));
        cfg.setMaxWaitMillis((long)this.conf.getInt("fastdfs.pool.maxWaitMillis", 6000));
        this.fastDfsClientFactory = new FastDfsClientFactory(prop);
        this.fastDfsClientPool = new FastDfsClientPool(this.fastDfsClientFactory, (GenericObjectPoolConfig<TrackerServer>)cfg);
        filePool = NutFilePool.getOrCreatePool((String)this.conf.get("fastdfs.filepool.path", Disks.home() + "/fastdfs_tmp"), (long)this.conf.getInt("fastdfs.filepool.size", 200));
    }

    public void close() {
        if (this.fastDfsClientPool != null) {
            this.fastDfsClientPool.close();
        }
    }

    public String getFileTokenUrl(String filename) {
        try {
            String baseUrl = this.conf.get("fastdfs.http_token_base_url", "");
            String secretKey = this.conf.get("fastdfs.http_secret_key", "");
            if (Strings.isBlank((CharSequence)filename) || Strings.isBlank((CharSequence)secretKey) || Strings.isBlank((CharSequence)baseUrl)) {
                log.info((Object)"[FastdfsService] filename & http_token_base_url & http_secret_key must not empty");
                return "";
            }
            int pos = filename.indexOf(FILENAME_SEPERATOR);
            String tokenFilename = filename.substring(pos + 1);
            long ts = Times.getTS();
            StringBuilder sb = new StringBuilder();
            sb.append(baseUrl);
            if (!baseUrl.endsWith(FILENAME_SEPERATOR)) {
                sb.append(FILENAME_SEPERATOR);
            }
            sb.append(filename);
            sb.append("?token=");
            sb.append(this.getToken(tokenFilename, ts, secretKey));
            sb.append("&ts=");
            sb.append(ts);
            return sb.toString();
        }
        catch (Exception e) {
            log.error((Object)e);
            return "";
        }
    }

    public String getImageTokenUrl(String filename, int type) {
        try {
            String baseUrl = this.conf.get("fastdfs.http_token_base_url", "");
            String secretKey = this.conf.get("fastdfs.http_secret_key", "");
            if (Strings.isBlank((CharSequence)filename) || Strings.isBlank((CharSequence)secretKey) || Strings.isBlank((CharSequence)baseUrl)) {
                log.info((Object)"[FastdfsService] filename & http_token_base_url & http_secret_key must not empty");
                return "";
            }
            int pos = filename.indexOf(FILENAME_SEPERATOR);
            String tokenFilename = filename.substring(pos + 1);
            tokenFilename = this.getFileName(type, tokenFilename);
            filename = this.getFileName(type, filename);
            long ts = Times.getTS();
            StringBuilder sb = new StringBuilder();
            sb.append(baseUrl);
            if (!baseUrl.endsWith(FILENAME_SEPERATOR)) {
                sb.append(FILENAME_SEPERATOR);
            }
            sb.append(filename);
            sb.append("?token=");
            sb.append(this.getToken(tokenFilename, ts, secretKey));
            sb.append("&ts=");
            sb.append(ts);
            return sb.toString();
        }
        catch (Exception e) {
            log.error((Object)e);
            return "";
        }
    }

    private String getToken(String filename, long timestamp, String secret_key) throws Exception {
        byte[] bsFilename = filename.getBytes(this.conf.get("fastdfs.charset", "UTF-8"));
        byte[] bsKey = secret_key.getBytes(this.conf.get("fastdfs.charset", "UTF-8"));
        byte[] bsTimestamp = new Long(timestamp).toString().getBytes(this.conf.get("fastdfs.charset", "UTF-8"));
        byte[] buff = new byte[bsFilename.length + bsKey.length + bsTimestamp.length];
        System.arraycopy(bsFilename, 0, buff, 0, bsFilename.length);
        System.arraycopy(bsKey, 0, buff, bsFilename.length, bsKey.length);
        System.arraycopy(bsTimestamp, 0, buff, bsFilename.length + bsKey.length, bsTimestamp.length);
        return Lang.digest((String)"MD5", (byte[])buff, null, (int)1);
    }

    private String getFileName(int type, String tokenFilename) {
        StringBuilder sb = new StringBuilder();
        String filename = tokenFilename.substring(0, tokenFilename.indexOf(EXT_SEPERATOR));
        String ext = tokenFilename.substring(tokenFilename.indexOf(EXT_SEPERATOR));
        sb.append(filename);
        switch (type) {
            case 1: {
                sb.append(IMAGE_WATERMARK_SUFFIX);
                break;
            }
            case 2: {
                sb.append(IMAGE_THUMB_SUFFIX);
            }
        }
        sb.append(ext);
        return sb.toString();
    }

    public String uploadFile(byte[] file, String ext, Map<String, String> metaInfo) {
        String path = "";
        TrackerServer trackerServer = null;
        StorageClient1 storageClient1 = null;
        try {
            trackerServer = (TrackerServer)this.fastDfsClientPool.borrowObject();
            storageClient1 = new StorageClient1(trackerServer, null);
            NameValuePair[] data = null;
            if (Lang.isNotEmpty(metaInfo)) {
                data = new NameValuePair[metaInfo.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : metaInfo.entrySet()) {
                    data[index] = new NameValuePair(entry.getKey(), entry.getValue());
                    ++index;
                }
            }
            path = storageClient1.uploadFile1(file, ext, data);
        }
        catch (Exception e) {
            throw Lang.makeThrow((String)"[FastdfsService] upload file error : %s", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            if (trackerServer != null) {
                this.fastDfsClientPool.returnObject(trackerServer);
            }
            storageClient1 = null;
        }
        return path;
    }

    public String uploadFile(String local_filename, String ext, Map<String, String> metaInfo) {
        String path = "";
        TrackerServer trackerServer = null;
        StorageClient1 storageClient1 = null;
        try {
            trackerServer = (TrackerServer)this.fastDfsClientPool.borrowObject();
            storageClient1 = new StorageClient1(trackerServer, null);
            NameValuePair[] data = null;
            if (Lang.isNotEmpty(metaInfo)) {
                data = new NameValuePair[metaInfo.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : metaInfo.entrySet()) {
                    data[index] = new NameValuePair(entry.getKey(), entry.getValue());
                    ++index;
                }
            }
            path = storageClient1.uploadFile1(local_filename, ext, data);
        }
        catch (Exception e) {
            throw Lang.makeThrow((String)"[FastdfsService] upload file error : %s", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            if (trackerServer != null) {
                this.fastDfsClientPool.returnObject(trackerServer);
            }
            storageClient1 = null;
        }
        return path;
    }

    public String uploadSalveFile(String local_filename, String originalPath, String prefixName, String ext, Map<String, String> metaInfo) {
        String path = "";
        TrackerServer trackerServer = null;
        StorageClient1 storageClient1 = null;
        try {
            trackerServer = (TrackerServer)this.fastDfsClientPool.borrowObject();
            storageClient1 = new StorageClient1(trackerServer, null);
            NameValuePair[] data = null;
            if (Lang.isNotEmpty(metaInfo)) {
                data = new NameValuePair[metaInfo.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : metaInfo.entrySet()) {
                    data[index] = new NameValuePair(entry.getKey(), entry.getValue());
                    ++index;
                }
            }
            path = storageClient1.uploadFile1(originalPath, prefixName, local_filename, ext, data);
        }
        catch (Exception e) {
            throw Lang.makeThrow((String)"[FastdfsService] upload file error : %s", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            if (trackerServer != null) {
                this.fastDfsClientPool.returnObject(trackerServer);
            }
            storageClient1 = null;
        }
        return path;
    }

    public String uploadSalveFile(byte[] file, String originalPath, String prefixName, String ext, Map<String, String> metaInfo) {
        String path = "";
        TrackerServer trackerServer = null;
        StorageClient1 storageClient1 = null;
        try {
            trackerServer = (TrackerServer)this.fastDfsClientPool.borrowObject();
            storageClient1 = new StorageClient1(trackerServer, null);
            NameValuePair[] data = null;
            if (Lang.isNotEmpty(metaInfo)) {
                data = new NameValuePair[metaInfo.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : metaInfo.entrySet()) {
                    data[index] = new NameValuePair(entry.getKey(), entry.getValue());
                    ++index;
                }
            }
            path = storageClient1.uploadFile1(originalPath, prefixName, file, ext, data);
        }
        catch (Exception e) {
            throw Lang.makeThrow((String)"[FastdfsService] upload file error : %s", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            if (trackerServer != null) {
                this.fastDfsClientPool.returnObject(trackerServer);
            }
            storageClient1 = null;
        }
        return path;
    }

    public byte[] downLoadFile(String fullFilename) {
        byte[] data = null;
        TrackerServer trackerServer = null;
        StorageClient1 storageClient1 = null;
        try {
            trackerServer = (TrackerServer)this.fastDfsClientPool.borrowObject();
            storageClient1 = new StorageClient1(trackerServer, null);
            data = storageClient1.downloadFile1(fullFilename);
        }
        catch (Exception e) {
            throw Lang.makeThrow((String)"[FastdfsService] download file error : %s", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            if (trackerServer != null) {
                this.fastDfsClientPool.returnObject(trackerServer);
            }
            storageClient1 = null;
        }
        return data;
    }

    public void downLoadFile(String fullFilename, OutputStream outputStream) {
        TrackerServer trackerServer = null;
        StorageClient1 storageClient1 = null;
        try {
            trackerServer = (TrackerServer)this.fastDfsClientPool.borrowObject();
            String suffx = fullFilename.substring(fullFilename.lastIndexOf(EXT_SEPERATOR));
            File file = filePool.createFile(suffx);
            storageClient1 = new StorageClient1(trackerServer, null);
            storageClient1.downloadFile1(fullFilename, file.getAbsolutePath());
            Streams.writeAndClose((OutputStream)outputStream, (InputStream)new FileInputStream(file));
        }
        catch (Exception e) {
            throw Lang.makeThrow((String)"[FastdfsService] download file error : %s", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            if (trackerServer != null) {
                this.fastDfsClientPool.returnObject(trackerServer);
            }
            storageClient1 = null;
        }
    }

    public int deleteFile(String fullFilename) {
        int result = 1;
        TrackerServer trackerServer = null;
        StorageClient1 storageClient1 = null;
        try {
            trackerServer = (TrackerServer)this.fastDfsClientPool.borrowObject();
            storageClient1 = new StorageClient1(trackerServer, null);
            result = storageClient1.deleteFile1(fullFilename);
        }
        catch (Exception e) {
            throw Lang.makeThrow((String)"[FastdfsService] delete file error : %s", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            if (trackerServer != null) {
                this.fastDfsClientPool.returnObject(trackerServer);
            }
            storageClient1 = null;
        }
        return result;
    }

    public String uploadImage(byte[] image, byte[] watermark, String ext, Map<String, String> metaInfo) {
        return this.uploadImage(image, watermark, ext, metaInfo, 0.5f, 5, 0);
    }

    public String uploadImage(byte[] image, byte[] watermark, String ext, Map<String, String> metaInfo, float opacity, int pos, int margin) {
        String path = "";
        TrackerServer trackerServer = null;
        StorageClient1 storageClient1 = null;
        ByteArrayOutputStream thumbOs = new ByteArrayOutputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            trackerServer = (TrackerServer)this.fastDfsClientPool.borrowObject();
            storageClient1 = new StorageClient1(trackerServer, null);
            NameValuePair[] data = null;
            if (Lang.isNotEmpty(metaInfo)) {
                data = new NameValuePair[metaInfo.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : metaInfo.entrySet()) {
                    data[index] = new NameValuePair(entry.getKey(), entry.getValue());
                    ++index;
                }
            }
            path = storageClient1.uploadFile1(image, ext, data);
            BufferedImage bufferedImage = Images.addWatermark((Object)image, (Object)watermark, (float)opacity, (int)pos, (int)margin);
            Images.write((RenderedImage)bufferedImage, (String)ext, (OutputStream)os);
            storageClient1.uploadFile1(path, IMAGE_WATERMARK_SUFFIX, os.toByteArray(), ext, data);
            BufferedImage read = Images.read((Object)image);
            BufferedImage bufferedImageThumb = Images.zoomScale((BufferedImage)read, (int)IMAGE_THUMB_WIDTH, (int)IMAGE_THUMB_HEIGHT);
            Images.write((RenderedImage)bufferedImageThumb, (String)ext, (OutputStream)thumbOs);
            storageClient1.uploadFile1(path, IMAGE_THUMB_SUFFIX, thumbOs.toByteArray(), ext, data);
        }
        catch (Exception e) {
            throw Lang.makeThrow((String)"[FastdfsService] upload images error : %s", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            Streams.safeClose((Closeable)os);
            Streams.safeClose((Closeable)thumbOs);
            try {
                if (trackerServer != null) {
                    this.fastDfsClientPool.returnObject(trackerServer);
                }
                storageClient1 = null;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return path;
    }

    public String uploadImage(byte[] image, byte[] watermark, String ext, Map<String, String> metaInfo, int mode, int margin_x, int margin_y, float opacity, int markAngle) {
        String path = "";
        TrackerServer trackerServer = null;
        StorageClient1 storageClient1 = null;
        ByteArrayOutputStream thumbOs = new ByteArrayOutputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            trackerServer = (TrackerServer)this.fastDfsClientPool.borrowObject();
            storageClient1 = new StorageClient1(trackerServer, null);
            NameValuePair[] data = null;
            if (Lang.isNotEmpty(metaInfo)) {
                data = new NameValuePair[metaInfo.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : metaInfo.entrySet()) {
                    data[index] = new NameValuePair(entry.getKey(), entry.getValue());
                    ++index;
                }
            }
            path = storageClient1.uploadFile1(image, ext, data);
            byte[] bytes = FastdfsService.markImage(new ByteArrayInputStream(image), new ByteArrayInputStream(watermark), ext, mode, margin_x, margin_y, opacity, markAngle);
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
            Images.write((RenderedImage)bufferedImage, (String)ext, (OutputStream)os);
            storageClient1.uploadFile1(path, IMAGE_WATERMARK_SUFFIX, os.toByteArray(), ext, data);
            BufferedImage read = Images.read((Object)image);
            BufferedImage bufferedImageThumb = Images.zoomScale((BufferedImage)read, (int)IMAGE_THUMB_WIDTH, (int)IMAGE_THUMB_HEIGHT);
            Images.write((RenderedImage)bufferedImageThumb, (String)ext, (OutputStream)thumbOs);
            storageClient1.uploadFile1(path, IMAGE_THUMB_SUFFIX, thumbOs.toByteArray(), ext, data);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw Lang.makeThrow((String)"[FastdfsService] upload images error : %s", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            Streams.safeClose((Closeable)os);
            Streams.safeClose((Closeable)thumbOs);
            try {
                if (trackerServer != null) {
                    this.fastDfsClientPool.returnObject(trackerServer);
                }
                storageClient1 = null;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return path;
    }

    public static byte[] markImage(InputStream originImgStream, InputStream markImgStream, String ext, int mode, int margin_x, int margin_y, float opacity, double markAngle) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (markAngle > 45.0 || markAngle < -45.0) {
            throw new RuntimeException("[FastdfsService] Rotation angle must be between positive and negative 45 degrees");
        }
        BufferedImage originImg = ImageIO.read(originImgStream);
        BufferedImage markImage = ImageIO.read(markImgStream);
        if (null == markImage) {
            ImageIO.write((RenderedImage)originImg, ext, os);
            return os.toByteArray();
        }
        Graphics2D graphics = (Graphics2D)originImg.getGraphics();
        graphics.setComposite(AlphaComposite.getInstance(10, opacity));
        graphics.rotate(markAngle);
        if (mode == 1) {
            int canvasHeight = originImg.getHeight();
            int canvasWidth = originImg.getWidth();
            int markHeight = markImage.getHeight();
            int markWidth = markImage.getHeight();
            int interval = markWidth + markHeight;
            int i = -canvasHeight;
            while (i < canvasWidth + canvasHeight) {
                int j = -canvasWidth;
                while (j < canvasHeight + canvasWidth) {
                    graphics.drawImage(markImage, i, j, markImage.getWidth(), markImage.getHeight(), null);
                    j = j + interval + margin_y;
                }
                i = i + interval + margin_x;
            }
        }
        graphics.dispose();
        ImageIO.write((RenderedImage)originImg, ext, os);
        return os.toByteArray();
    }
}

