/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.sentinel;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.util.AssertUtil;
import org.nutz.integration.jedis.RedisService;
import org.nutz.integration.jedis.pubsub.PubSub;
import org.nutz.integration.jedis.pubsub.PubSubService;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class SentinelReadableDataSource<T>
extends AbstractDataSource<String, T>
implements PubSub {
    private static final Log log = Logs.get();
    private PubSubService pubSubService;
    private RedisService redisService;
    private String ruleKey;

    public SentinelReadableDataSource(RedisService redisService, PubSubService pubSubService, String ruleKey, String channel, Converter<String, T> parser) {
        super(parser);
        AssertUtil.notEmpty((String)ruleKey, (String)"Redis ruleKey can not be empty");
        AssertUtil.notEmpty((String)channel, (String)"Redis subscribe channel can not be empty");
        this.pubSubService = pubSubService;
        this.redisService = redisService;
        this.ruleKey = ruleKey;
        this.loadInitialConfig();
        this.subscribeFromChannel(channel);
    }

    private void subscribeFromChannel(String channel) {
        log.debugf("[SentinelRedisDataSource] subscribeFromChannel:::%s", new Object[]{channel});
        this.pubSubService.reg(channel, (PubSub)this);
    }

    public void onMessage(String channel, String message) {
        log.debugf("[SentinelRedisDataSource] onMessage:::%s,%s", new Object[]{channel, message});
        this.getProperty().updateValue(this.parser.convert((Object)message));
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue != null) {
                this.getProperty().updateValue(newValue);
            }
        }
        catch (Exception ex) {
            log.warn((Object)"[SentinelRedisDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    public void close() {
    }

    public String readSource() {
        return this.redisService.get(this.ruleKey);
    }
}

