/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.sentinel;

import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterParamFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.transport.util.WritableDataSourceRegistry;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.boot.starter.ServerFace;
import org.nutz.boot.starter.sentinel.SentinelReadableDataSource;
import org.nutz.boot.starter.sentinel.SentinelWritableDataSource;
import org.nutz.integration.jedis.RedisService;
import org.nutz.integration.jedis.pubsub.PubSubService;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class SentinelStarter
implements ServerFace {
    private static final Log log = Logs.get();
    private static final String PRE = "sentinel.";
    @Inject(value="refer:$ioc")
    protected Ioc ioc;
    @Inject
    protected PropertiesProxy conf;
    private PubSubService pubSubService;
    private RedisService redisService;
    private static final String CONSOLE_SERVER = "csp.sentinel.dashboard.server";
    private static final String SERVER_PORT = "csp.sentinel.api.port";
    private static final String HEARTBEAT_INTERVAL_MS = "csp.sentinel.heartbeat.interval.ms";
    private static final String HEARTBEAT_CLIENT_IP = "csp.sentinel.heartbeat.client.ip";
    @PropDoc(value="\u662f\u5426\u542f\u52a8Sentinel\u5ba2\u6237\u7aef", defaultValue="false", type="boolean")
    public static final String PROP_ENABLED = "sentinel.enabled";
    @PropDoc(value="Sentinel\u5ba2\u6237\u7aef\u540d\u79f0,\u4e0d\u8bbe\u7f6e\u5219\u81ea\u52a8\u83b7\u53d6nutz.application.name", type="string")
    public static final String PROP_PROJECR_NAME = "sentinel.project.name";
    @PropDoc(value="Sentinel\u5ba2\u6237\u7aef\u7aef\u53e3", defaultValue="8721", type="int")
    public static final String PROP_SERVER_PORT = "sentinel.csp.sentinel.api.port";
    @PropDoc(value="Sentinel\u63a7\u5236\u53f0\u5730\u5740", defaultValue="localhost:9090", type="string")
    public static final String PROP_CONSOLE_SERVER = "sentinel.csp.sentinel.dashboard.server";
    @PropDoc(value="Sentinel\u5ba2\u6237\u7aef\u901a\u4fe1\u95f4\u9694\u6beb\u79d2\u6570", defaultValue="3000", type="int")
    public static final String PROP_HEARTBEAT_INTERVAL_MS = "sentinel.csp.sentinel.heartbeat.interval.ms";
    @PropDoc(value="Sentinel\u5ba2\u6237\u7aefIP,\u4e0d\u914d\u7f6e\u5219\u81ea\u52a8\u83b7\u53d6\u672c\u5730IP", defaultValue="", type="string")
    public static final String PROP_HEARTBEAT_CLIENT_IP = "sentinel.csp.sentinel.heartbeat.client.ip";
    @PropDoc(value="Sentinel\u89c4\u5219\u5b58\u50a8key\u503c", defaultValue="nutzboot", type="string")
    public static final String PROP_RULEKEY = "sentinel.rulekey";
    @PropDoc(value="Sentinel\u89c4\u5219\u5b58\u50a8channel\u503c", defaultValue="sentinel", type="string")
    public static final String PROP_CHANNEL = "sentinel.channel";

    public void start() throws Exception {
        if (this.conf.getBoolean(PROP_ENABLED, false)) {
            this.redisService = (RedisService)this.ioc.get(RedisService.class);
            this.pubSubService = (PubSubService)this.ioc.get(PubSubService.class);
            System.setProperty("java.net.preferIPv4Stack", "true");
            System.setProperty("project.name", this.conf.get(PROP_PROJECR_NAME, this.conf.get("nutz.application.name", this.conf.get("dubbo.application.name", ""))));
            System.setProperty(CONSOLE_SERVER, this.conf.get(PROP_CONSOLE_SERVER, "localhost:9090"));
            System.setProperty(HEARTBEAT_INTERVAL_MS, this.conf.get(PROP_HEARTBEAT_INTERVAL_MS, "3000"));
            String ip = this.conf.get(PROP_HEARTBEAT_CLIENT_IP, "");
            int port = this.conf.getInt(PROP_SERVER_PORT, 0);
            if (port == 0) {
                port = this.getRandPort(ip);
            }
            System.setProperty(HEARTBEAT_CLIENT_IP, ip);
            System.setProperty(SERVER_PORT, "" + port);
            this.registerFlowRuleSupplier();
            this.registerSystemRuleSupplier();
            this.registerAuthorityRuleSupplier();
            this.registerDegradeRuleSupplier();
            this.registerClusterRuleSupplier();
            log.infof("sentinel started in %s:%s", new Object[]{TransportConfig.getHeartbeatClientIp(), TransportConfig.getPort()});
        }
    }

    private void registerFlowRuleSupplier() {
        SentinelReadableDataSource redisDataSource = new SentinelReadableDataSource(this.redisService, this.pubSubService, this.conf.get(PROP_RULEKEY, "nutzboot") + "-flow-rule", this.conf.get(PROP_CHANNEL, "sentinel") + "-flow-rule", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]));
        FlowRuleManager.register2Property((SentinelProperty)redisDataSource.getProperty());
        SentinelWritableDataSource wds = new SentinelWritableDataSource(this.redisService, this::encodeJson, this.conf.get(PROP_RULEKEY, "nutzboot") + "-flow-rule");
        WritableDataSourceRegistry.registerFlowDataSource(wds);
    }

    private void registerSystemRuleSupplier() {
        SentinelReadableDataSource redisDataSource = new SentinelReadableDataSource(this.redisService, this.pubSubService, this.conf.get(PROP_RULEKEY, "nutzboot") + "-system-rule", this.conf.get(PROP_CHANNEL, "sentinel") + "-system-rule", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<SystemRule>>(){}, (Feature[])new Feature[0]));
        SystemRuleManager.register2Property((SentinelProperty)redisDataSource.getProperty());
        SentinelWritableDataSource wds = new SentinelWritableDataSource(this.redisService, this::encodeJson, this.conf.get(PROP_RULEKEY, "nutzboot") + "-system-rule");
        WritableDataSourceRegistry.registerSystemDataSource(wds);
    }

    private void registerAuthorityRuleSupplier() {
        SentinelReadableDataSource redisDataSource = new SentinelReadableDataSource(this.redisService, this.pubSubService, this.conf.get(PROP_RULEKEY, "nutzboot") + "-authority-rule", this.conf.get(PROP_CHANNEL, "sentinel") + "-authority-rule", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<AuthorityRule>>(){}, (Feature[])new Feature[0]));
        AuthorityRuleManager.register2Property((SentinelProperty)redisDataSource.getProperty());
        SentinelWritableDataSource wds = new SentinelWritableDataSource(this.redisService, this::encodeJson, this.conf.get(PROP_RULEKEY, "nutzboot") + "-authority-rule");
        WritableDataSourceRegistry.registerAuthorityDataSource(wds);
    }

    private void registerDegradeRuleSupplier() {
        SentinelReadableDataSource redisDataSource = new SentinelReadableDataSource(this.redisService, this.pubSubService, this.conf.get(PROP_RULEKEY, "nutzboot") + "-degrade-rule", this.conf.get(PROP_CHANNEL, "sentinel") + "-degrade-rule", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<DegradeRule>>(){}, (Feature[])new Feature[0]));
        DegradeRuleManager.register2Property((SentinelProperty)redisDataSource.getProperty());
        SentinelWritableDataSource wds = new SentinelWritableDataSource(this.redisService, this::encodeJson, this.conf.get(PROP_RULEKEY, "nutzboot") + "-degrade-rule");
        WritableDataSourceRegistry.registerDegradeDataSource(wds);
    }

    private void registerClusterRuleSupplier() {
        ClusterFlowRuleManager.setPropertySupplier(namespace -> {
            SentinelReadableDataSource ds = new SentinelReadableDataSource(this.redisService, this.pubSubService, this.conf.get(PROP_RULEKEY, "nutzboot") + namespace + "-cluster-flow-rule", this.conf.get(PROP_CHANNEL, "sentinel") + namespace + "-cluster-flow-rule", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]));
            return ds.getProperty();
        });
        ClusterParamFlowRuleManager.setPropertySupplier(namespace -> {
            SentinelReadableDataSource ds = new SentinelReadableDataSource(this.redisService, this.pubSubService, this.conf.get(PROP_RULEKEY, "nutzboot") + namespace + "-param-flow-rule", this.conf.get(PROP_CHANNEL, "sentinel") + namespace + "-param-flow-rule", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ParamFlowRule>>(){}, (Feature[])new Feature[0]));
            return ds.getProperty();
        });
        SentinelReadableDataSource namespaceDs = new SentinelReadableDataSource(this.redisService, this.pubSubService, this.conf.get(PROP_RULEKEY, "nutzboot") + "-namespace", this.conf.get(PROP_CHANNEL, "sentinel") + "-namespace", source -> (Set)JSON.parseObject((String)source, (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]));
        ClusterServerConfigManager.registerNamespaceSetProperty((SentinelProperty)namespaceDs.getProperty());
        SentinelReadableDataSource transportConfigDs = new SentinelReadableDataSource(this.redisService, this.pubSubService, this.conf.get(PROP_RULEKEY, "nutzboot") + "-transport", this.conf.get(PROP_CHANNEL, "sentinel") + "-transport", source -> (ServerTransportConfig)JSON.parseObject((String)source, (TypeReference)new TypeReference<ServerTransportConfig>(){}, (Feature[])new Feature[0]));
        ClusterServerConfigManager.registerServerTransportProperty((SentinelProperty)transportConfigDs.getProperty());
    }

    private <T> String encodeJson(T t) {
        return JSON.toJSONString(t);
    }

    private int getRandPort(String host) {
        int port = 20000 + new Random(System.currentTimeMillis()).nextInt(2000);
        if (this.isPortUsing(host, port)) {
            return this.getRandPort(host);
        }
        return port;
    }

    private boolean isPortUsing(String ip, int port) {
        boolean flag = false;
        try {
            Socket socket = new Socket();
            socket.setReceiveBufferSize(8192);
            socket.setSoTimeout(1000);
            InetSocketAddress address = new InetSocketAddress(ip, port);
            socket.connect(address, 1000);
            if (socket.isConnected()) {
                flag = true;
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flag;
    }

    public void stop() throws Exception {
    }

    public boolean isRunning() {
        return this.conf.getBoolean(PROP_ENABLED, false);
    }
}

