/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.sentinel;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.nutz.integration.jedis.RedisService;

public class SentinelWritableDataSource<T>
implements WritableDataSource<T> {
    private RedisService redisService;
    private String ruleKey;
    private final Converter<T, String> configEncoder;
    private final Lock lock = new ReentrantLock(true);

    public SentinelWritableDataSource(RedisService redisService, Converter<T, String> configEncoder, String ruleKey) {
        this.redisService = redisService;
        this.configEncoder = configEncoder;
        this.ruleKey = ruleKey;
    }

    public void write(T value) throws Exception {
        this.lock.lock();
        try {
            String convertResult = (String)this.configEncoder.convert(value);
            this.redisService.set(this.ruleKey, convertResult);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws Exception {
    }
}

