/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ssdb4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.nutz.ssdb4j.impl.SimpleClient;
import org.nutz.ssdb4j.pool.PoolSSDBStream;
import org.nutz.ssdb4j.pool.Pools;
import org.nutz.ssdb4j.replication.ReplicationSSDMStream;
import org.nutz.ssdb4j.spi.Cmd;
import org.nutz.ssdb4j.spi.Response;
import org.nutz.ssdb4j.spi.ResponseFactory;
import org.nutz.ssdb4j.spi.SSDB;
import org.nutz.ssdb4j.spi.SSDBException;

public class SSDBs {
    public static String DEFAULT_HOST = "127.0.0.1";
    public static int DEFAULT_PORT = 8888;
    public static int DEFAULT_TIMEOUT = 2000;
    public static Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final byte[] EMPTY_ARG = new byte[0];
    public static ResponseFactory respFactory = new ResponseFactory();

    public static final SSDB simple() {
        return SSDBs.simple(DEFAULT_HOST, DEFAULT_PORT, DEFAULT_TIMEOUT);
    }

    public static final SSDB simple(String host, int port, int timeout) {
        return new SimpleClient(host, port, timeout);
    }

    public static final SSDB pool(String host, int port, int timeout, Object config) {
        return SSDBs.pool(host, port, timeout, config, null);
    }

    public static final SSDB pool(String host, int port, int timeout, Object config, byte[] auth) {
        return new SimpleClient(SSDBs._pool(host, port, timeout, config, auth));
    }

    protected static final PoolSSDBStream _pool(String host, int port, int timeout, Object config, byte[] auth) {
        return Pools.pool(host, port, timeout, config, auth);
    }

    public static final SSDB replication(String masterHost, int masterPort, String slaveHost, int slavePort, int timeout, Object config) {
        return SSDBs.replication(masterHost, masterPort, slaveHost, slavePort, timeout, config, null, null);
    }

    public static final SSDB replication(String masterHost, int masterPort, String slaveHost, int slavePort, int timeout, Object config, byte[] masterAuth, byte[] slaveAuth) {
        PoolSSDBStream master = SSDBs._pool(masterHost, masterPort, timeout, config, masterAuth);
        PoolSSDBStream slave = SSDBs._pool(slaveHost, slavePort, timeout, config, slaveAuth);
        return new SimpleClient(new ReplicationSSDMStream(master, slave));
    }

    public static byte[] readBlock(InputStream in) throws IOException {
        int len = 0;
        int d = in.read();
        if (d == 10) {
            return null;
        }
        if (d >= 48 && d <= 57) {
            len = len * 10 + (d - 48);
        } else {
            throw new SSDBException("protocol error. unexpect byte=" + d);
        }
        while ((d = in.read()) >= 48 && d <= 57) {
            len = len * 10 + (d - 48);
        }
        if (d != 10) {
            throw new SSDBException("protocol error. unexpect byte=" + d);
        }
        byte[] data = new byte[len];
        if (len > 0) {
            int count = 0;
            int r = 0;
            while (count < len) {
                r = in.read(data, count, len - count > 8192 ? 8192 : len - count);
                if (r > 0) {
                    count += r;
                    continue;
                }
                if (r != -1) continue;
                throw new SSDBException("protocol error. unexpect stream end!");
            }
        }
        if ((d = in.read()) != 10) {
            throw new SSDBException("protocol error. unexpect byte=" + d);
        }
        return data;
    }

    public static void writeBlock(OutputStream out, byte[] data) throws IOException {
        if (data == null) {
            data = EMPTY_ARG;
        }
        out.write(Integer.toString(data.length).getBytes());
        out.write(10);
        out.write(data);
        out.write(10);
    }

    public static void sendCmd(OutputStream out, Cmd cmd, byte[] ... vals) throws IOException {
        SSDBs.writeBlock(out, cmd.bytes());
        byte[][] byArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] bs = byArray[n2];
            SSDBs.writeBlock(out, bs);
            ++n2;
        }
        out.write(10);
        out.flush();
    }

    public static Response readResp(InputStream in) throws IOException {
        Response resp = respFactory.make();
        byte[] data = SSDBs.readBlock(in);
        if (data == null) {
            throw new SSDBException("protocol error. unexpect \\n");
        }
        resp.stat = new String(data);
        while ((data = SSDBs.readBlock(in)) != null) {
            resp.datas.add(data);
        }
        return resp;
    }

    public static String version() {
        return "9.2";
    }
}

