/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ssdb4j.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.nutz.ssdb4j.SSDBs;
import org.nutz.ssdb4j.spi.Cmd;
import org.nutz.ssdb4j.spi.Response;
import org.nutz.ssdb4j.spi.SSDBException;
import org.nutz.ssdb4j.spi.SSDBStream;
import org.nutz.ssdb4j.spi.SSDBStreamCallback;

public abstract class AbstractIoSSDBStream
implements SSDBStream {
    protected InputStream in;
    protected OutputStream out;

    public synchronized Response req(Cmd cmd, byte[] ... vals) {
        this.beforeExec();
        try {
            SSDBs.sendCmd(this.out, cmd, vals);
            Response resp = SSDBs.readResp(this.in);
            this.beforeReturn(resp);
            return resp;
        }
        catch (Throwable e) {
            return this.whenError(e);
        }
    }

    protected void beforeExec() {
    }

    protected void beforeReturn(Response resp) {
    }

    protected Response whenError(Throwable e) {
        throw new SSDBException(e);
    }

    public void callback(SSDBStreamCallback callback) {
        this.beforeExec();
        try {
            callback.invoke(this.in, this.out);
        }
        catch (Throwable e) {
            this.whenError(e);
        }
    }
}

