/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ssdb4j.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.nutz.ssdb4j.impl.BatchClient;
import org.nutz.ssdb4j.impl.DefaultObjectConv;
import org.nutz.ssdb4j.impl.SocketSSDBStream;
import org.nutz.ssdb4j.spi.Cmd;
import org.nutz.ssdb4j.spi.ObjectConv;
import org.nutz.ssdb4j.spi.Response;
import org.nutz.ssdb4j.spi.SSDB;
import org.nutz.ssdb4j.spi.SSDBException;
import org.nutz.ssdb4j.spi.SSDBStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleClient
implements SSDB {
    protected SSDBStream stream;
    protected ObjectConv conv;

    public SimpleClient(SSDBStream stream) {
        this.stream = stream;
        this.conv = DefaultObjectConv.me;
    }

    public SimpleClient(String host, int port, int timeout) {
        this.stream = new SocketSSDBStream(host, port, timeout);
        this.conv = DefaultObjectConv.me;
    }

    protected byte[] bytes(Object obj) {
        return this.conv.bytes(obj);
    }

    protected byte[][] bytess(Object ... objs) {
        return this.conv.bytess(objs);
    }

    protected Response req(Cmd cmd, byte[] first, byte[][] lots) {
        byte[][] vals = new byte[lots.length + 1][];
        vals[0] = first;
        int i = 0;
        while (i < lots.length) {
            vals[i + 1] = lots[i];
            ++i;
        }
        return this.req(cmd, vals);
    }

    @Override
    public Response req(Cmd cmd, byte[] ... vals) {
        return this.stream.req(cmd, vals);
    }

    @Override
    public SSDB batch() {
        return new BatchClient(this.stream, 60, TimeUnit.SECONDS);
    }

    public SSDB batch(int timeout, TimeUnit timeUnit) {
        return new BatchClient(this.stream, timeout, timeUnit);
    }

    @Override
    public List<Response> exec() {
        throw new SSDBException("not batch!");
    }

    public void setObjectConv(ObjectConv conv) {
        this.conv = conv;
    }

    @Override
    public void changeObjectConv(ObjectConv conv) {
        this.setObjectConv(conv);
    }

    public void setSSDBStream(SSDBStream stream) {
        this.stream = stream;
    }

    @Override
    public Response get(Object key) {
        return this.req(Cmd.get, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response set(Object key, Object val) {
        return this.req(Cmd.set, this.bytes(key), this.bytes(val));
    }

    @Override
    public Response setx(Object key, Object val, int ttl) {
        return this.req(Cmd.setx, this.bytes(key), this.bytes(val), Integer.toString(ttl).getBytes());
    }

    @Override
    public Response del(Object key) {
        return this.req(Cmd.del, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response incr(Object key, int val) {
        return this.req(Cmd.incr, this.bytes(key), Integer.toString(val).getBytes());
    }

    @Override
    public Response exists(Object key) {
        return this.req(Cmd.exists, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response keys(Object start, Object end, int limit) {
        return this.req(Cmd.keys, this.bytes(start), this.bytes(end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response multi_set(Object ... pairs) {
        return this.req(Cmd.multi_set, this.bytess(pairs));
    }

    @Override
    public Response multi_get(Object ... keys) {
        return this.req(Cmd.multi_get, this.bytess(keys));
    }

    @Override
    public Response multi_del(Object ... keys) {
        return this.req(Cmd.multi_del, this.bytess(keys));
    }

    @Override
    public Response scan(Object start, Object end, int limit) {
        return this.req(Cmd.scan, this.bytes(start), this.bytes(end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response rscan(Object start, Object end, int limit) {
        return this.req(Cmd.rscan, this.bytes(start), this.bytes(end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response hset(Object key, Object hkey, Object hval) {
        return this.req(Cmd.hset, this.bytes(key), this.bytes(hkey), this.bytes(hval));
    }

    @Override
    public Response hdel(Object key, Object hkey) {
        return this.req(Cmd.hdel, this.bytes(key), this.bytes(hkey));
    }

    @Override
    public Response hget(Object key, Object hkey) {
        return this.req(Cmd.hget, this.bytes(key), this.bytes(hkey));
    }

    @Override
    public Response hsize(Object key) {
        return this.req(Cmd.hsize, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response hlist(Object key, Object hkey, int limit) {
        return this.req(Cmd.hlist, this.bytes(key), this.bytes(hkey), Integer.toString(limit).getBytes());
    }

    @Override
    public Response hincr(Object key, Object hkey, int val) {
        return this.req(Cmd.hincr, this.bytes(key), this.bytes(hkey), Integer.toString(val).getBytes());
    }

    @Override
    public Response hscan(Object key, Object start, Object end, int limit) {
        return this.req(Cmd.hscan, this.bytes(key), this.bytes(start), this.bytes(end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response hrscan(Object key, Object start, Object end, int limit) {
        return this.req(Cmd.hrscan, this.bytes(key), this.bytes(start), this.bytes(end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response zset(Object key, Object zkey, long score) {
        return this.req(Cmd.zset, this.bytes(key), this.bytes(zkey), Long.toString(score).getBytes());
    }

    @Override
    public Response zget(Object key, Object zkey) {
        return this.req(Cmd.zget, this.bytes(key), this.bytes(zkey));
    }

    @Override
    public Response zdel(Object key, Object zkey) {
        return this.req(Cmd.zdel, this.bytes(key), this.bytes(zkey));
    }

    @Override
    public Response zincr(Object key, Object zkey, int val) {
        return this.req(Cmd.zincr, this.bytes(key), this.bytes(zkey), Integer.toString(val).getBytes());
    }

    @Override
    public Response zsize(Object key) {
        return this.req(Cmd.zsize, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response zlist(Object zkey_start, Object zkey_end, int limit) {
        return this.req(Cmd.zlist, this.bytes(zkey_start), this.bytes(zkey_end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response zrank(Object key, Object zkey) {
        return this.req(Cmd.zrank, this.bytes(key), this.bytes(zkey));
    }

    @Override
    public Response zrrank(Object key, Object zkey) {
        return this.req(Cmd.zrrank, this.bytes(key), this.bytes(zkey));
    }

    @Override
    public Response zscan(Object key, Object zkey_start, Object score_start, Object score_end, int limit) {
        return this.req(Cmd.zscan, this.bytes(key), this.bytes(zkey_start), this.bytes(score_start), this.bytes(score_end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response zrscan(Object key, Object zkey_start, Object score_start, Object score_end, int limit) {
        return this.req(Cmd.zrscan, this.bytes(key), this.bytes(zkey_start), this.bytes(score_start), this.bytes(score_end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response qsize(Object key) {
        return this.req(Cmd.qsize, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response qfront(Object key) {
        return this.req(Cmd.qfront, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response qback(Object key) {
        return this.req(Cmd.qback, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response qpush(Object key, Object value) {
        return this.req(Cmd.qpush, this.bytes(key), this.bytes(value));
    }

    @Override
    public Response qpop(Object key) {
        return this.req(Cmd.qpop, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response qlist(Object key_start, Object key_end, int limit) {
        return this.req(Cmd.qlist, this.bytes(key_start), this.bytes(key_end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response qclear(Object key) {
        return this.req(Cmd.qclear, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response hkeys(Object key, Object start, Object end, int limit) {
        return this.req(Cmd.hkeys, this.bytes(key), this.bytes(start), this.bytes(end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response hexists(Object key, Object hkey) {
        return this.req(Cmd.hexists, this.bytes(key), this.bytes(hkey));
    }

    @Override
    public Response hclear(Object key) {
        return this.req(Cmd.hclear, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response multi_hget(Object key, Object ... hkeys) {
        return this.req(Cmd.multi_hget, this.bytes(key), this.bytess(hkeys));
    }

    @Override
    public Response multi_hset(Object key, Object ... pairs) {
        return this.req(Cmd.multi_hset, this.bytes(key), this.bytess(pairs));
    }

    @Override
    public Response multi_hdel(Object key, Object ... hkeys) {
        return this.req(Cmd.multi_hdel, this.bytes(key), this.bytess(hkeys));
    }

    @Override
    public Response zexists(Object key, Object zkey) {
        return this.req(Cmd.zexists, this.bytes(key), this.bytes(zkey));
    }

    @Override
    public Response zclear(Object key) {
        return this.req(Cmd.zclear, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response zkeys(Object key, Object zkey_start, Object score_start, Object score_end, int limit) {
        return this.req(Cmd.zkeys, this.bytes(key), this.bytes(zkey_start), this.bytes(score_start), this.bytes(score_end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response zrange(Object key, int offset, int limit) {
        return this.req(Cmd.zrange, this.bytes(key), Integer.toString(offset).getBytes(), Integer.toString(limit).getBytes());
    }

    @Override
    public Response zrrange(Object key, int offset, int limit) {
        return this.req(Cmd.zrrange, this.bytes(key), Integer.toString(offset).getBytes(), Integer.toString(limit).getBytes());
    }

    @Override
    public Response multi_zset(Object key, Object ... pairs) {
        return this.req(Cmd.multi_zset, this.bytes(key), this.bytess(pairs));
    }

    @Override
    public Response multi_zget(Object key, Object ... zkeys) {
        return this.req(Cmd.multi_zget, this.bytes(key), this.bytess(zkeys));
    }

    @Override
    public Response multi_zdel(Object key, Object ... zkeys) {
        return this.req(Cmd.multi_zdel, this.bytes(key), this.bytess(zkeys));
    }

    @Override
    public Response flushdb(String type) {
        if (type == null || type.length() == 0) {
            this.flushdb_kv();
            this.flushdb_hash();
            this.flushdb_zset();
            this.flushdb_list();
        } else if ("kv".equals(type)) {
            this.flushdb_kv();
        } else if ("hash".equals(type)) {
            this.flushdb_hash();
        } else if ("zset".equals(type)) {
            this.flushdb_zset();
        } else if ("list".equals(type)) {
            this.flushdb_list();
        } else {
            throw new IllegalArgumentException("not such flushdb mode=" + type);
        }
        Response resp = new Response();
        resp.stat = "ok";
        return resp;
    }

    protected long flushdb_kv() {
        long count = 0L;
        List<String> keys;
        while (!(keys = this.keys("", "", 1000).check().listString()).isEmpty()) {
            count += (long)keys.size();
            this.multi_del(keys.toArray());
        }
        return count;
    }

    protected long flushdb_hash() {
        long count = 0L;
        List<String> keys;
        block0: while (!(keys = this.hlist("", "", 1000).check().listString()).isEmpty()) {
            count += (long)keys.size();
            Iterator<String> iterator = keys.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                String key = iterator.next();
                this.hclear(key);
            }
            break;
        }
        return count;
    }

    protected long flushdb_zset() {
        long count = 0L;
        List<String> keys;
        block0: while (!(keys = this.zlist("", "", 1000).check().listString()).isEmpty()) {
            count += (long)keys.size();
            Iterator<String> iterator = keys.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                String key = iterator.next();
                this.zclear(key);
            }
            break;
        }
        return count;
    }

    protected long flushdb_list() {
        long count = 0L;
        List<String> keys;
        block0: while (!(keys = this.qlist("", "", 1000).check().listString()).isEmpty()) {
            count += (long)keys.size();
            Iterator<String> iterator = keys.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                String key = iterator.next();
                this.qclear(key);
            }
            break;
        }
        return count;
    }

    @Override
    public Response info() {
        return this.req(Cmd.info, new byte[0][]);
    }

    @Override
    public Response ping() {
        return this.req(Cmd.ping, new byte[0][]);
    }

    @Override
    public Response setnx(Object key, Object val) {
        return this.req(Cmd.setnx, this.bytes(key), this.bytes(val));
    }

    @Override
    public Response getset(Object key, Object val) {
        return this.req(Cmd.getset, this.bytes(key), this.bytes(val));
    }

    @Override
    public Response qslice(Object key, int start, int end) {
        return this.req(Cmd.qslice, this.bytes(key), Integer.toString(start).getBytes(), Integer.toString(end).getBytes());
    }

    @Override
    public Response qget(Object key, int index) {
        return this.req(Cmd.qget, this.bytes(key), Integer.toString(index).getBytes());
    }

    @Override
    public Response zcount(Object key, int start, int end) {
        return this.req(Cmd.zcount, this.bytes(key), Integer.toString(start).getBytes(), Integer.toString(end).getBytes());
    }

    @Override
    public Response zsum(Object key, int start, int end) {
        return this.req(Cmd.zsum, this.bytes(key), Integer.toString(start).getBytes(), Integer.toString(end).getBytes());
    }

    @Override
    public Response zavg(Object key, int start, int end) {
        return this.req(Cmd.zavg, this.bytes(key), Integer.toString(start).getBytes(), Integer.toString(end).getBytes());
    }

    @Override
    public Response eval(Object key, Object ... args) {
        return this.req(Cmd.eval, this.bytes(key), this.bytess(args));
    }

    @Override
    public Response evalsha(Object sha1, Object ... args) {
        return this.req(Cmd.evalsha, this.bytes(sha1), this.bytess(args));
    }

    @Override
    public Response ttl(Object key) {
        return this.req(Cmd.ttl, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response decr(Object key, int val) {
        return this.req(Cmd.decr, this.bytes(key), Integer.toString(val).getBytes());
    }

    @Override
    public Response multi_exists(Object ... keys) {
        return this.req(Cmd.multi_exists, this.bytess(keys));
    }

    @Override
    public Response hdecr(Object key, Object hkey, int val) {
        return this.req(Cmd.hdecr, this.bytes(key), this.bytes(hkey), Integer.toString(val).getBytes());
    }

    @Override
    public Response hgetall(Object key) {
        return this.req(Cmd.hgetall, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response hvals(Object key, Object start, Object end, int limit) {
        return this.req(Cmd.hvals, this.bytes(key), this.bytes(start), this.bytes(end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response multi_hexists(Object ... keys) {
        return this.req(Cmd.hvals, this.bytess(keys));
    }

    @Override
    public Response multi_hsize(Object ... keys) {
        return this.req(Cmd.multi_hsize, new byte[][]{this.bytes(keys)});
    }

    @Override
    public Response zdecr(Object key, Object zkey, int val) {
        return this.req(Cmd.zdecr, this.bytes(key), this.bytes(zkey), Integer.toString(val).getBytes());
    }

    @Override
    public Response zremrangebyrank(Object key, Object score_start, Object score_end) {
        return this.req(Cmd.zremrangebyrank, this.bytes(key), this.bytes(score_start), this.bytes(score_end));
    }

    @Override
    public Response zremrangebyscore(Object key, Object score_start, Object score_end) {
        return this.req(Cmd.zremrangebyscore, this.bytes(key), this.bytes(score_start), this.bytes(score_end));
    }

    @Override
    public Response multi_zexists(Object key, Object ... zkeys) {
        return this.req(Cmd.zexists, this.bytes(key), this.bytess(zkeys));
    }

    @Override
    public Response multi_zsize(Object ... keys) {
        return this.req(Cmd.zsize, this.bytess(keys));
    }

    @Override
    public Response qpush_back(Object key, Object value) {
        return this.req(Cmd.qpush_back, this.bytes(key), this.bytes(value));
    }

    @Override
    public Response qpush_front(Object key, Object value) {
        return this.req(Cmd.qpush_front, this.bytes(key), this.bytes(value));
    }

    @Override
    public Response qpop_back(Object key) {
        return this.req(Cmd.qpop_back, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response qpop_front(Object key) {
        return this.req(Cmd.qpop_front, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response qrange(Object key, int begin, int limit) {
        return this.req(Cmd.qrange, this.bytes(key), Integer.toString(begin).getBytes(), Integer.toString(limit).getBytes());
    }

    @Override
    public Response qfix(Object key) {
        return this.req(Cmd.qfix, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response dump() {
        return this.req(Cmd.dump, new byte[0][]);
    }

    @Override
    public Response clear_binlog() {
        return this.req(Cmd.clear_binlog, new byte[0][]);
    }

    @Override
    public Response compact() {
        return this.req(Cmd.compact, new byte[0][]);
    }

    @Override
    public Response expire(Object key, int ttl) {
        return this.req(Cmd.expire, this.bytes(key), Integer.toString(ttl).getBytes());
    }

    @Override
    public Response key_range() {
        return this.req(Cmd.key_range, new byte[0][]);
    }

    @Override
    public Response sync140() {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public Response getbit(Object key, int offset) {
        return this.req(Cmd.getbit, this.bytes(key), Integer.toString(offset).getBytes());
    }

    @Override
    public Response setbit(Object key, int offset, byte on) {
        return this.req(Cmd.setbit, this.bytes(key), Integer.toString(offset).getBytes(), on == 1 ? "1".getBytes() : "0".getBytes());
    }

    @Override
    public Response countbit(Object key, int start, int size) {
        return this.req(Cmd.countbit, this.bytes(key), Integer.toString(start).getBytes(), Integer.toString(size).getBytes());
    }

    @Override
    public Response substr(Object key, int start, int size) {
        if (size < 0) {
            size = 2000000000;
        }
        return this.req(Cmd.strlen, this.bytes(key), Integer.toString(start).getBytes(), Integer.toString(size).getBytes());
    }

    @Override
    public Response getrange(Object key, int start, int size) {
        return this.req(Cmd.getrange, this.bytes(key), Integer.toString(start).getBytes(), Integer.toString(size).getBytes());
    }

    @Override
    public Response strlen(Object key) {
        return this.req(Cmd.strlen, new byte[][]{this.bytes(key)});
    }

    @Override
    public Response redis_bitcount(Object key, int start, int size) {
        return this.req(Cmd.redis_bitcount, this.bytes(key), Integer.toString(start).getBytes(), Integer.toString(size).getBytes());
    }

    @Override
    public Response hrlist(Object key, Object hkey, int limit) {
        return this.req(Cmd.hrlist, this.bytes(key), this.bytes(hkey), Integer.toString(limit).getBytes());
    }

    @Override
    public Response zrlist(Object zkey_start, Object zkey_end, int limit) {
        return this.req(Cmd.zrlist, this.bytes(zkey_start), this.bytes(zkey_end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response qrlist(Object key_start, Object key_end, int limit) {
        return this.req(Cmd.qrlist, this.bytes(key_start), this.bytes(key_end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response auth(String passwd) {
        return this.req(Cmd.auth, new byte[][]{this.bytes(passwd)});
    }

    @Override
    public Response qtrim_back(Object key, int size) {
        return this.req(Cmd.qtrim_back, this.bytes(key), Integer.toString(size).getBytes());
    }

    @Override
    public Response qtrim_front(Object key, int size) {
        return this.req(Cmd.qtrim_front, this.bytes(key), Integer.toString(size).getBytes());
    }

    @Override
    public Response dbsize() {
        return this.req(Cmd.dbsize, new byte[0][]);
    }

    @Override
    public Response qset(Object key, int index, Object value) {
        return this.req(Cmd.qset, this.bytes(key), Integer.toString(index).getBytes(), this.bytes(value));
    }

    @Override
    public Response get_key_range() {
        return this.get_kv_range();
    }

    @Override
    public Response get_kv_range() {
        return this.req(Cmd.get_kv_range, new byte[0][]);
    }

    @Override
    public Response set_kv_range(Object start, Object end) {
        return this.req(Cmd.set_kv_range, this.bytes(start), this.bytes(end));
    }

    @Override
    public Response qpop_back(Object key, int limit) {
        return this.req(Cmd.qpop_back, this.bytes(key), Integer.toString(limit).getBytes());
    }

    @Override
    public Response qpop_front(Object key, int limit) {
        return this.req(Cmd.qpop_front, this.bytes(key), Integer.toString(limit).getBytes());
    }

    @Override
    public Response version() {
        return this.req(Cmd.version, new byte[0][]);
    }

    @Override
    public Response rkeys(Object start, Object end, int limit) {
        return this.req(Cmd.rkeys, this.bytes(start), this.bytes(end), Integer.toString(limit).getBytes());
    }

    @Override
    public Response ignore_key_range() {
        return this.req(Cmd.ignore_key_range, new byte[0][]);
    }
}

