/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ssdb4j.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.nutz.ssdb4j.SSDBs;
import org.nutz.ssdb4j.impl.AbstractIoSSDBStream;
import org.nutz.ssdb4j.spi.Cmd;
import org.nutz.ssdb4j.spi.Response;
import org.nutz.ssdb4j.spi.SSDBException;

public class SocketSSDBStream
extends AbstractIoSSDBStream {
    private Socket socket = new Socket();
    protected String host;
    protected int port;
    protected int timeout;
    protected byte[] auth;

    public SocketSSDBStream(String host, int port, int timeout) {
        this(host, port, timeout, null);
    }

    public SocketSSDBStream(String host, int port, int timeout, byte[] auth) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.auth = auth;
    }

    protected void beforeExec() {
        if (!this.socket.isConnected()) {
            try {
                this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeout);
                this.socket.setSoTimeout(this.timeout);
                this.in = new BufferedInputStream(this.socket.getInputStream());
                this.out = new BufferedOutputStream(this.socket.getOutputStream());
                if (this.auth != null) {
                    SSDBs.sendCmd(this.out, Cmd.auth, new byte[][]{this.auth});
                    if (!SSDBs.readResp(this.in).ok()) {
                        throw new IOException("auth fail");
                    }
                }
            }
            catch (IOException e) {
                throw new SSDBException(e);
            }
        }
    }

    protected Response whenError(Throwable e) {
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return super.whenError(e);
    }

    public void close() throws IOException {
        this.socket.close();
    }
}

