/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ssdb4j.jni;

import java.io.IOException;
import org.nutz.ssdb4j.spi.Cmd;
import org.nutz.ssdb4j.spi.Response;
import org.nutz.ssdb4j.spi.SSDBStream;
import org.nutz.ssdb4j.spi.SSDBStreamCallback;

public class JniSSDB
implements SSDBStream {
    static {
        System.loadLibrary("ssdb");
        System.loadLibrary("ssdbjni");
    }

    public JniSSDB(String path) {
        int re = this._init(path);
        if (re != 0) {
            throw new IllegalArgumentException("re=" + re);
        }
    }

    public Response req(Cmd cmd, byte[] ... vals) {
        byte[][] re = this._req(cmd.bytes(), vals);
        Response resp = new Response();
        if (re == null || re.length == 0) {
            resp.stat = "error";
            return resp;
        }
        resp.stat = new String(re[0]);
        if (re.length > 1) {
            int i = 1;
            while (i < re.length) {
                resp.datas.add(re[i]);
                ++i;
            }
        }
        return resp;
    }

    public void callback(SSDBStreamCallback callback) {
        throw new RuntimeException("JNI Not impl callback");
    }

    public void close() throws IOException {
        int re = this._close();
        if (re != 0) {
            throw new IOException("re=" + re);
        }
    }

    protected native int _init(String var1);

    protected native byte[][] _req(byte[] var1, byte[] ... var2);

    protected native int _close();
}

